/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.ImmutableSet;

class ItemNamePattern
implements RestrictionPattern {
    private final Set<String> names;

    ItemNamePattern(Iterable<String> names) {
        this.names = ImmutableSet.copyOf(names);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        if (property != null) {
            return this.names.contains(property.getName());
        }
        return this.names.contains(tree.getName());
    }

    @Override
    public boolean matches(@NotNull String path) {
        return !PathUtils.denotesRoot(path) && this.names.contains(PathUtils.getName(path));
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        return this.names.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemNamePattern) {
            ItemNamePattern other = (ItemNamePattern)obj;
            return this.names.equals(other.names);
        }
        return false;
    }
}

