/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositePermissionProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.Util;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompositePermissionProviderAnd
extends CompositePermissionProvider {
    CompositePermissionProviderAnd(@NotNull Root root, @NotNull List<AggregatedPermissionProvider> pps, @NotNull Context acContext, @NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider) {
        super(root, pps, acContext, rootProvider, treeProvider);
    }

    @Override
    @NotNull
    CompositeAuthorizationConfiguration.CompositionType getCompositeType() {
        return CompositeAuthorizationConfiguration.CompositionType.AND;
    }

    @Override
    @NotNull
    RepositoryPermission createRepositoryPermission() {
        return new CompositeRepositoryPermission();
    }

    @Override
    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        Tree immutableTree = PermissionUtil.getReadOnlyTreeOrNull(tree, this.getImmutableRoot());
        PrivilegeBits result = PrivilegeBits.getInstance();
        PrivilegeBits denied = PrivilegeBits.getInstance();
        PrivilegeBitsProvider bitsProvider = this.getBitsProvider();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.getPermissionProviders()) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, null).modifiable();
            if (!Util.doEvaluate(supported)) continue;
            PrivilegeBits granted = bitsProvider.getBits(aggregatedPermissionProvider.getPrivileges(immutableTree));
            if (!granted.isEmpty()) {
                result.add(granted);
            }
            denied.add(supported.diff(granted));
        }
        if (!denied.isEmpty()) {
            result.diff(denied);
        }
        return bitsProvider.getPrivilegeNames(result);
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        Tree immutableTree = PermissionUtil.getReadOnlyTreeOrNull(tree, this.getImmutableRoot());
        PrivilegeBitsProvider bitsProvider = this.getBitsProvider();
        PrivilegeBits privilegeBits = bitsProvider.getBits(privilegeNames);
        if (privilegeBits.isEmpty()) {
            return true;
        }
        boolean hasPrivileges = false;
        PrivilegeBits coveredPrivs = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.getPermissionProviders()) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(immutableTree, privilegeBits);
            if (!Util.doEvaluate(supported)) continue;
            Set<String> supportedNames = bitsProvider.getPrivilegeNames(supported);
            hasPrivileges = aggregatedPermissionProvider.hasPrivileges(immutableTree, supportedNames.toArray(new String[0]));
            if (!hasPrivileges) {
                return false;
            }
            coveredPrivs.add(supported);
        }
        return hasPrivileges && coveredPrivs.includes(privilegeBits);
    }

    @Override
    public boolean isGranted(@NotNull Tree parent, @Nullable PropertyState property, long permissions) {
        Tree immParent = PermissionUtil.getReadOnlyTree(parent, this.getImmutableRoot());
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.getPermissionProviders()) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(immParent, property, permissions);
            if (!Util.doEvaluate(supportedPermissions)) continue;
            isGranted = aggregatedPermissionProvider.isGranted(immParent, property, supportedPermissions);
            if (!isGranted) {
                return false;
            }
            coveredPermissions |= supportedPermissions;
        }
        return isGranted && coveredPermissions == permissions;
    }

    @Override
    public boolean isGranted(@NotNull TreeLocation location, long permissions) {
        Tree tree;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return this.isGranted(tree, property, permissions);
        }
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.getPermissionProviders()) {
            long supportedPermissions = aggregatedPermissionProvider.supportedPermissions(location, permissions);
            if (!Util.doEvaluate(supportedPermissions)) continue;
            isGranted = aggregatedPermissionProvider.isGranted(location, supportedPermissions);
            if (!isGranted) {
                return false;
            }
            coveredPermissions |= supportedPermissions;
        }
        return isGranted && coveredPermissions == permissions;
    }

    private final class CompositeRepositoryPermission
    implements RepositoryPermission {
        private CompositeRepositoryPermission() {
        }

        @Override
        public boolean isGranted(long repositoryPermissions) {
            boolean isGranted = false;
            long coveredPermissions = 0L;
            for (AggregatedPermissionProvider aggregatedPermissionProvider : CompositePermissionProviderAnd.this.getPermissionProviders()) {
                long supportedPermissions = aggregatedPermissionProvider.supportedPermissions((Tree)null, null, repositoryPermissions);
                if (!Util.doEvaluate(supportedPermissions)) continue;
                RepositoryPermission rp = aggregatedPermissionProvider.getRepositoryPermission();
                isGranted = rp.isGranted(supportedPermissions);
                if (!isGranted) {
                    return false;
                }
                coveredPermissions |= supportedPermissions;
            }
            return isGranted && coveredPermissions == repositoryPermissions;
        }
    }
}

