/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.itemsave;

import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.FailingValidator;
import org.apache.jackrabbit.oak.spi.commit.SubtreeExcludingValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import sling-mock-oak.com.google.common.collect.Lists;

class ItemSaveValidator
extends SubtreeExcludingValidator {
    private final String ignorePropertyChange;

    public ItemSaveValidator(String path) {
        this(new FailingValidator("Unsupported", 0, "Failed to save subtree at " + path + ". There are transient modifications outside that subtree."), Lists.newArrayList(PathUtils.elements(path)));
    }

    private ItemSaveValidator(Validator validator, List<String> path) {
        super(validator, path);
        this.ignorePropertyChange = path.size() == 1 ? path.get(0) : null;
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!before.getName().equals(this.ignorePropertyChange)) {
            super.propertyChanged(before, after);
        }
    }

    @Override
    protected SubtreeExcludingValidator createValidator(Validator validator, List<String> path) {
        return new ItemSaveValidator(validator, path);
    }
}

