/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.query.QueryImpl;
import org.apache.jackrabbit.oak.jcr.query.QueryResultImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManagerImpl
implements QueryManager {
    private static final Logger queryOpsLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.query");
    private final SessionDelegate sessionDelegate;
    private final SessionContext sessionContext;
    private final QueryObjectModelFactoryImpl qomFactory;
    private final QueryEngine queryEngine;
    private final HashSet<String> supportedQueryLanguages = new HashSet();
    private final MeterStats queryCount;
    private final TimerStats queryDuration;

    public QueryManagerImpl(SessionContext sessionContext) {
        this.sessionDelegate = sessionContext.getSessionDelegate();
        this.sessionContext = sessionContext;
        this.qomFactory = new QueryObjectModelFactoryImpl(this, sessionContext);
        this.queryEngine = this.sessionDelegate.getQueryEngine();
        this.supportedQueryLanguages.addAll(this.queryEngine.getSupportedQueryLanguages());
        this.queryCount = sessionContext.getMeter(RepositoryStatistics.Type.QUERY_COUNT);
        this.queryDuration = sessionContext.getTimer(RepositoryStatistics.Type.QUERY_DURATION);
    }

    public QueryImpl createQuery(String statement, String language) throws RepositoryException {
        if (!this.supportedQueryLanguages.contains(language)) {
            throw new InvalidQueryException("The specified language is not supported: " + language);
        }
        return new QueryImpl(this, statement, language, this.sessionContext);
    }

    public QueryObjectModelFactory getQOMFactory() {
        return this.qomFactory;
    }

    public Query getQuery(Node node) throws RepositoryException {
        if (!node.isNodeType("nt:query")) {
            throw new InvalidQueryException("Not an nt:query node: " + node.getPath());
        }
        String statement = node.getProperty("jcr:statement").getString();
        String language = node.getProperty("jcr:language").getString();
        QueryImpl query = this.createQuery(statement, language);
        query.setStoredQueryPath(node.getPath());
        return query;
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>(this.queryEngine.getSupportedQueryLanguages());
        list.add("JCR-JQOM");
        return list.toArray(new String[list.size()]);
    }

    public List<String> parse(String statement, String language) throws InvalidQueryException {
        try {
            return this.queryEngine.getBindVariableNames(statement, language, this.sessionContext.getSessionLocalMappings());
        }
        catch (ParseException e) {
            throw new InvalidQueryException((Throwable)e);
        }
    }

    public QueryResult executeQuery(String statement, String language, long limit, long offset, HashMap<String, Value> bindVariableMap) throws RepositoryException {
        try {
            Map<String, PropertyValue> bindMap = QueryManagerImpl.convertMap(bindVariableMap);
            TimerStats.Context context = this.queryDuration.time();
            Result r = this.queryEngine.executeQuery(statement, language, limit, offset, bindMap, this.sessionContext.getSessionLocalMappings());
            this.queryCount.mark();
            long millis = TimeUnit.NANOSECONDS.toMillis(context.stop());
            queryOpsLogger.debug("Executed query [{}] in [{}] ms", (Object)statement, (Object)millis);
            this.sessionContext.getStatisticManager().logQueryEvaluationTime(language, statement, millis);
            return new QueryResultImpl(this.sessionContext, r);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException((Throwable)e);
        }
        catch (ParseException e) {
            throw new InvalidQueryException((Throwable)e);
        }
    }

    private static Map<String, PropertyValue> convertMap(HashMap<String, Value> bindVariableMap) throws RepositoryException {
        HashMap<String, PropertyValue> map = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, Value> e : bindVariableMap.entrySet()) {
            map.put(e.getKey(), PropertyValues.create(PropertyStates.createProperty("", e.getValue())));
        }
        return map;
    }

    void ensureIsAlive() throws RepositoryException {
        if (!this.sessionDelegate.isAlive()) {
            throw new RepositoryException("This session has been closed.");
        }
    }
}

