/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.testing.junit.rules.Condition;
import org.apache.sling.testing.junit.rules.annotation.IgnoreIf;
import org.apache.sling.testing.junit.rules.annotation.IgnoreIfProperties;
import org.apache.sling.testing.junit.rules.annotation.IgnoreIfProperty;
import org.apache.sling.testing.junit.rules.util.IgnoreTestsConfig;
import org.apache.sling.testing.junit.rules.util.Match;
import org.junit.AssumptionViolatedException;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRule.class);
    public static final String CATEGORY_PROPERTY = "filterCategory";
    public static final String INCLUDE_CATEGORY_PROPERTY = "runOnlyFilteredCategories";
    private List<String> defaultCategories = new ArrayList<String>();

    public Statement apply(Statement base, Description description) {
        Match match;
        IgnoreIfProperty ignoreIfProperty;
        IgnoreIf ignoreIf = (IgnoreIf)description.getAnnotation(IgnoreIf.class);
        if (null != ignoreIf) {
            for (Class<? extends Condition> condClass : Arrays.asList(ignoreIf.value())) {
                try {
                    Constructor<? extends Condition> constructor = condClass.getConstructor(new Class[0]);
                    Condition cond = constructor.newInstance(new Object[0]);
                    if (!cond.satisfy()) continue;
                    return this.emptyStatement("IgnoreIf condition met to skip: " + cond.description());
                }
                catch (Exception e) {
                    LOG.error("Error getting condition object", (Throwable)e);
                }
            }
        }
        ArrayList<IgnoreIfProperty> ignoreIfPropertyList = new ArrayList<IgnoreIfProperty>();
        IgnoreIfProperties ignoreIfProperties = (IgnoreIfProperties)description.getAnnotation(IgnoreIfProperties.class);
        if (null != ignoreIfProperties) {
            ignoreIfPropertyList.addAll(Arrays.asList(ignoreIfProperties.value()));
        }
        if (null != (ignoreIfProperty = (IgnoreIfProperty)description.getAnnotation(IgnoreIfProperty.class))) {
            ignoreIfPropertyList.add(ignoreIfProperty);
        }
        for (IgnoreIfProperty ignoreIfProp : ignoreIfPropertyList) {
            if (null == System.getProperty(ignoreIfProp.name()) || !System.getProperty(ignoreIfProp.name()).equals(ignoreIfProp.value())) continue;
            return this.emptyStatement("IgnoreIfProperty condition met to skip: system property '" + ignoreIfProp.name() + "' is equal to '" + ignoreIfProp.value() + "'.");
        }
        String fqdn = description.getClassName();
        String methodName = description.getMethodName();
        if (null != methodName) {
            fqdn = fqdn + "#" + methodName;
        }
        if ((match = IgnoreTestsConfig.get().match(fqdn)).isIgnored()) {
            return this.emptyStatement(match.getReason());
        }
        List<String> filteredCategories = System.getProperty(CATEGORY_PROPERTY) != null ? Arrays.asList(System.getProperty(CATEGORY_PROPERTY).split(",")) : this.defaultCategories;
        Category testCategory = (Category)description.getAnnotation(Category.class);
        Class[] testCategories = new Class[]{};
        if (testCategory != null) {
            testCategories = testCategory.value();
        }
        if (System.getProperty(INCLUDE_CATEGORY_PROPERTY) == null) {
            for (Class category : testCategories) {
                if (!filteredCategories.contains(category.getSimpleName())) continue;
                return this.emptyStatement("Excluding category: " + category.getSimpleName());
            }
        } else {
            boolean categorySelected = false;
            for (Class category : testCategories) {
                if (!filteredCategories.contains(category.getSimpleName())) continue;
                categorySelected = true;
            }
            if (!categorySelected) {
                return this.emptyStatement("Test has no category in (runOnlyFilteredCategories=true): '" + filteredCategories + "'");
            }
        }
        return base;
    }

    private Statement emptyStatement(final String reason) {
        return new Statement(){

            public void evaluate() throws Throwable {
                throw new AssumptionViolatedException("Test was ignored by FilterRule: " + reason);
            }
        };
    }

    public FilterRule addDefaultIgnoreCategories(Class ... ignoredCategories) {
        for (Class c : ignoredCategories) {
            this.defaultCategories.add(c.getSimpleName());
        }
        return this;
    }
}

