/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.freemarker.internal;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.scripting.core.servlet.CaptureResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TemplateModel.class}, property={"namespace=sling", "name=include"})
public class IncludeDirective
implements TemplateDirectiveModel {
    private static final String ADD_SELECTORS_PARAMETER_NAME = "addSelectors";
    private static final String REPLACE_SELECTORS_PARAMETER_NAME = "replaceSelectors";
    private static final String REPLACE_SUFFIX_PARAMETER_NAME = "replaceSuffix";
    private static final String RESOURCE_TYPE_PARAMETER_NAME = "resourceType";
    private final Logger logger = LoggerFactory.getLogger(IncludeDirective.class);

    public void execute(Environment environment, Map parameters, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        SlingHttpServletRequest slingHttpServletRequest = (SlingHttpServletRequest)DeepUnwrap.unwrap((TemplateModel)environment.getVariable("request"));
        if (slingHttpServletRequest == null) {
            throw new TemplateException("request is null", environment);
        }
        SlingHttpServletResponse slingHttpServletResponse = (SlingHttpServletResponse)DeepUnwrap.unwrap((TemplateModel)environment.getVariable("response"));
        if (slingHttpServletResponse == null) {
            throw new TemplateException("response is null", environment);
        }
        TemplateModel templateModel = (TemplateModel)parameters.get("include");
        if (templateModel == null) {
            throw new TemplateException("include is null", environment);
        }
        Object include = DeepUnwrap.unwrap((TemplateModel)templateModel);
        if (include == null) {
            throw new TemplateException("unwrapping include failed", environment);
        }
        String path = null;
        if (include instanceof String) {
            path = (String)include;
        }
        Resource resource = null;
        if (include instanceof Resource) {
            resource = (Resource)include;
        }
        if (path == null && resource == null) {
            throw new TemplateException("path and resource are null", environment);
        }
        RequestDispatcherOptions requestDispatcherOptions = this.prepareRequestDispatcherOptions(parameters);
        String content = this.dispatch(resource, path, slingHttpServletRequest, slingHttpServletResponse, requestDispatcherOptions);
        if (content == null) {
            throw new TemplateException("dispatching request failed, content is null", environment);
        }
        environment.getOut().write(content);
    }

    protected <T> T unwrapParameter(String name, Map params, Class<T> type) throws TemplateModelException {
        Object parameter = params.get(name);
        TemplateModel templateModel = (TemplateModel)parameter;
        return (T)DeepUnwrap.unwrap((TemplateModel)templateModel);
    }

    protected RequestDispatcherOptions prepareRequestDispatcherOptions(Map params) throws TemplateModelException {
        String resourceType = this.unwrapParameter(RESOURCE_TYPE_PARAMETER_NAME, params, String.class);
        String replaceSelectors = this.unwrapParameter(REPLACE_SELECTORS_PARAMETER_NAME, params, String.class);
        String addSelectors = this.unwrapParameter(ADD_SELECTORS_PARAMETER_NAME, params, String.class);
        String replaceSuffix = this.unwrapParameter(REPLACE_SUFFIX_PARAMETER_NAME, params, String.class);
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType(resourceType);
        options.setReplaceSelectors(replaceSelectors);
        options.setAddSelectors(addSelectors);
        options.setReplaceSuffix(replaceSuffix);
        return options;
    }

    protected String dispatch(Resource resource, String path, SlingHttpServletRequest slingHttpServletRequest, SlingHttpServletResponse slingHttpServletResponse, RequestDispatcherOptions requestDispatcherOptions) {
        block12: {
            if (path != null) {
                if (!path.startsWith("/")) {
                    path = slingHttpServletRequest.getResource().getPath() + "/" + path;
                }
                path = ResourceUtil.normalize((String)path);
            }
            if (resource == null) {
                if (path == null) {
                    resource = slingHttpServletRequest.getResource();
                } else {
                    String resourceType = requestDispatcherOptions.getForceResourceType();
                    Resource tmp = slingHttpServletRequest.getResourceResolver().resolve(path);
                    if (tmp == null && resourceType != null) {
                        resource = new SyntheticResource(slingHttpServletRequest.getResourceResolver(), path, resourceType);
                        requestDispatcherOptions.remove((Object)"forceResourceType");
                    }
                }
            }
            try {
                RequestDispatcher dispatcher = resource != null ? slingHttpServletRequest.getRequestDispatcher(resource, requestDispatcherOptions) : slingHttpServletRequest.getRequestDispatcher(path, requestDispatcherOptions);
                if (dispatcher != null) {
                    try {
                        CaptureResponseWrapper wrapper = new CaptureResponseWrapper((HttpServletResponse)slingHttpServletResponse);
                        dispatcher.include((ServletRequest)slingHttpServletRequest, (ServletResponse)wrapper);
                        if (!wrapper.isBinaryResponse()) {
                            return wrapper.getCapturedCharacterResponse();
                        }
                        break block12;
                    }
                    catch (ServletException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block12;
                }
                this.logger.error("no request dispatcher: unable to include {}/'{}'", (Object)resource, (Object)path);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

