/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.adapter;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

final class MapConverter {
    private MapConverter() {
    }

    public static Map<String, Object> mapArrayToList(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getValue().getClass().isArray()) continue;
            Class<?> componentType = entry.getValue().getClass().getComponentType();
            if (componentType == Integer.TYPE) {
                entry.setValue(Arrays.asList(ArrayUtils.toObject((int[])((int[])entry.getValue()))));
                continue;
            }
            if (componentType == Long.TYPE) {
                entry.setValue(Arrays.asList(ArrayUtils.toObject((long[])((long[])entry.getValue()))));
                continue;
            }
            if (componentType == Double.TYPE) {
                entry.setValue(Arrays.asList(ArrayUtils.toObject((double[])((double[])entry.getValue()))));
                continue;
            }
            if (componentType == Boolean.TYPE) {
                entry.setValue(Arrays.asList(ArrayUtils.toObject((boolean[])((boolean[])entry.getValue()))));
                continue;
            }
            entry.setValue(Arrays.asList((Object[])entry.getValue()));
        }
        return map;
    }

    public static Map<String, Object> mapListToArray(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            List list = (List)entry.getValue();
            if (list.size() == 0) {
                entry.setValue(null);
                continue;
            }
            Class<?> type = list.get(0).getClass();
            entry.setValue(list.toArray((Object[])Array.newInstance(type, list.size())));
        }
        return map;
    }
}

