/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractAuthorizablePostServlet;
import org.apache.sling.servlets.post.Modification;

public abstract class AbstractGroupPostServlet
extends AbstractAuthorizablePostServlet {
    private static final long serialVersionUID = 1159063041816944076L;

    protected void updateGroupMembership(Resource baseResource, Map<String, ?> properties, Authorizable authorizable, List<Modification> changes) throws RepositoryException {
        if (authorizable.isGroup()) {
            String[] membersToAdd;
            String[] membersToDelete;
            Group group = (Group)authorizable;
            String groupPath = this.systemUserManagerPaths.getGroupPrefix() + group.getID();
            ResourceResolver resolver = baseResource.getResourceResolver();
            boolean changed = false;
            UserManager userManager = ((JackrabbitSession)resolver.adaptTo(Session.class)).getUserManager();
            for (String member : membersToDelete = this.convertToStringArray(properties.get(":member@Delete"))) {
                Authorizable memberAuthorizable = this.getAuthorizable(baseResource, member, userManager, resolver);
                if (memberAuthorizable == null) continue;
                group.removeMember(memberAuthorizable);
                changed = true;
            }
            for (String member : membersToAdd = this.convertToStringArray(properties.get(":member"))) {
                Authorizable memberAuthorizable = this.getAuthorizable(baseResource, member, userManager, resolver);
                if (memberAuthorizable == null) continue;
                group.addMember(memberAuthorizable);
                changed = true;
            }
            if (changed) {
                changes.add(Modification.onModified((String)(groupPath + "/members")));
            }
        }
    }

    private Authorizable getAuthorizable(Resource baseResource, String member, UserManager userManager, ResourceResolver resolver) {
        Resource res;
        Authorizable memberAuthorizable = null;
        try {
            memberAuthorizable = userManager.getAuthorizable(member);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (memberAuthorizable == null && (res = resolver.getResource(baseResource, member)) != null) {
            memberAuthorizable = (Authorizable)res.adaptTo(Authorizable.class);
        }
        return memberAuthorizable;
    }
}

