/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class BundleInfo {
    private static final String MAVEN_SNAPSHOT_MARKER = "SNAPSHOT";
    public final String symbolicName;
    public final Version version;
    public final int state;
    public final long id;

    public BundleInfo(String symbolicName, Version version, int state, long id) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.state = state;
        this.id = id;
    }

    private BundleInfo(Bundle b) {
        this.symbolicName = b.getSymbolicName();
        this.version = b.getVersion();
        this.state = b.getState();
        this.id = b.getBundleId();
    }

    public static BundleInfo getBundleInfo(BundleContext bundleContext, String symbolicName, String version) {
        Bundle b = BundleInfo.getMatchingBundle(bundleContext, symbolicName, version);
        if (b == null) {
            return null;
        }
        return new BundleInfo(b);
    }

    public static Bundle getMatchingBundle(BundleContext bundleContext, String bundleSymbolicName, String version) {
        Bundle match = null;
        if (bundleSymbolicName != null) {
            Bundle[] bundles;
            if ("system.bundle".equals(bundleSymbolicName)) {
                return bundleContext.getBundle("System Bundle");
            }
            ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
            for (Bundle bundle : bundles = bundleContext.getBundles()) {
                if (!bundleSymbolicName.equals(bundle.getSymbolicName())) continue;
                matchingBundles.add(bundle);
            }
            if (matchingBundles.size() > 0) {
                Version searchVersion;
                Version version2 = searchVersion = version == null ? null : new Version(version);
                if (searchVersion == null || searchVersion.compareTo(((Bundle)matchingBundles.get(0)).getVersion()) == 0) {
                    match = (Bundle)matchingBundles.get(0);
                }
                for (int i = 1; i < matchingBundles.size(); ++i) {
                    Bundle current = (Bundle)matchingBundles.get(i);
                    if (searchVersion == null) {
                        if (match.getVersion().compareTo(current.getVersion()) >= 0) continue;
                        match = current;
                        continue;
                    }
                    if (searchVersion.compareTo(current.getVersion()) != 0) continue;
                    match = current;
                    break;
                }
            }
        }
        return match;
    }

    public static boolean isSnapshot(Version v) {
        return v.toString().indexOf(MAVEN_SNAPSHOT_MARKER) >= 0;
    }
}

