/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.sling.feature.apiregions.impl.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

class RegionConfiguration {
    private static final String BUNDLE_LOCATION_TO_FEATURE_FILE = "bundleLocationToFeature.properties";
    private static final String REGION_ORDER = "__region.order__";
    volatile Map<Map.Entry<String, Version>, List<String>> bsnVerMap;
    volatile Map<String, Set<String>> bundleFeatureMap;
    volatile Map<String, List<String>> featureRegionMap;
    volatile Map<String, Set<String>> regionPackageMap;
    final Set<String> defaultRegions;
    private final Dictionary<String, Object> regProps = new Hashtable<String, Object>();
    private final Map<String, Dictionary<String, Object>> factoryConfigs = new ConcurrentHashMap<String, Dictionary<String, Object>>();
    private final Map<Map.Entry<String, Version>, List<String>> baseBsnVerMap;
    private final Map<String, Set<String>> baseBundleFeatureMap;
    private final Map<String, List<String>> baseFeatureRegionMap;
    private final Map<String, Set<String>> baseRegionPackageMap;
    private final List<String> globalRegionOrder;
    private final ConcurrentMap<String, Map.Entry<String, Version>> bundleLocationConfigMap = new ConcurrentHashMap<String, Map.Entry<String, Version>>();
    private final String toGlobalConfig;

    RegionConfiguration(Map<Map.Entry<String, Version>, List<String>> bsnVerMap, Map<String, Set<String>> bundleFeatureMap, Map<String, List<String>> featureRegionMap, Map<String, Set<String>> regionPackageMap, Set<String> defaultRegions) {
        this.defaultRegions = defaultRegions;
        this.baseBsnVerMap = new HashMap<Map.Entry<String, Version>, List<String>>(bsnVerMap);
        this.baseBundleFeatureMap = new HashMap<String, Set<String>>(bundleFeatureMap);
        this.baseFeatureRegionMap = new HashMap<String, List<String>>(featureRegionMap);
        this.baseRegionPackageMap = new HashMap<String, Set<String>>(regionPackageMap);
        this.globalRegionOrder = new ArrayList<String>(this.baseFeatureRegionMap.getOrDefault(REGION_ORDER, Collections.emptyList()));
        this.baseFeatureRegionMap.remove(REGION_ORDER);
        this.toGlobalConfig = null;
        this.updateConfiguration();
    }

    RegionConfiguration(BundleContext context) throws IOException, URISyntaxException {
        String defRegProp;
        URI idbsnverFile = this.getDataFileURI(context, "idbsnver.properties");
        this.regProps.put("idbsnver.properties", idbsnverFile.toString());
        Map<Map.Entry<String, Version>, List<String>> bvm = RegionConfiguration.populateBSNVerMap(idbsnverFile);
        URI bundlesFile = this.getDataFileURI(context, "bundles.properties");
        this.regProps.put("bundles.properties", bundlesFile.toString());
        Map<String, Set<String>> bfm = RegionConfiguration.populateBundleFeatureMap(bundlesFile);
        URI featuresFile = this.getDataFileURI(context, "features.properties");
        this.regProps.put("features.properties", featuresFile.toString());
        Map<String, List<String>> frm = RegionConfiguration.populateFeatureRegionMap(featuresFile);
        URI regionsFile = this.getDataFileURI(context, "regions.properties");
        this.regProps.put("regions.properties", regionsFile.toString());
        Map<String, Set<String>> rpm = RegionConfiguration.populateRegionPackageMap(regionsFile);
        this.baseBsnVerMap = bvm;
        this.baseBundleFeatureMap = bfm;
        this.baseFeatureRegionMap = frm;
        this.baseRegionPackageMap = rpm;
        this.globalRegionOrder = new ArrayList<String>(this.baseFeatureRegionMap.getOrDefault(REGION_ORDER, Collections.emptyList()));
        this.baseFeatureRegionMap.remove(REGION_ORDER);
        this.toGlobalConfig = context.getProperty("sling.feature.apiregions.joinglobal");
        if (this.toGlobalConfig != null) {
            this.regProps.put("sling.feature.apiregions.joinglobal", this.toGlobalConfig);
        }
        if ((defRegProp = context.getProperty("sling.feature.apiregions.default")) != null) {
            HashSet<String> defRegs = new HashSet<String>();
            for (String region : Arrays.asList(defRegProp.split(","))) {
                if (region.length() <= 0) continue;
                defRegs.add(region);
            }
            this.defaultRegions = Collections.unmodifiableSet(defRegs);
            if (this.defaultRegions.size() > 0) {
                this.regProps.put("sling.feature.apiregions.default", this.defaultRegions.toString());
            }
        } else {
            this.defaultRegions = Collections.emptySet();
        }
        this.loadLocationToConfigMap(context);
        this.updateConfiguration();
    }

    private void loadLocationToConfigMap(BundleContext context) {
        File file = context.getBundle().getDataFile(BUNDLE_LOCATION_TO_FEATURE_FILE);
        if (file != null && file.exists()) {
            Properties p = new Properties();
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                p.load(is);
            }
            catch (IOException e) {
                Activator.LOG.log(Level.WARNING, "Unable to load bundleLocationToFeature.properties", e);
            }
            for (String k : p.stringPropertyNames()) {
                Map.Entry<String, Version> bsnver = this.parseBSNVer(p.getProperty(k));
                if (bsnver == null) continue;
                this.bundleLocationConfigMap.put(k, bsnver);
            }
        }
    }

    private Map.Entry<String, Version> parseBSNVer(String val) {
        String[] bsnver = val.split("~");
        if (bsnver.length == 2) {
            String bsn = bsnver[0].trim();
            Version ver = null;
            try {
                ver = Version.parseVersion((String)bsnver[1].trim());
            }
            catch (Exception e) {
                Activator.LOG.log(Level.WARNING, "Problem parsing bundleLocationToFeature.properties", e);
            }
            if (ver != null) {
                return new AbstractMap.SimpleEntry<String, Version>(bsn, ver);
            }
        }
        return null;
    }

    void storeLocationToConfigMap(BundleContext context) {
        File file = context.getBundle().getDataFile(BUNDLE_LOCATION_TO_FEATURE_FILE);
        if (file == null) {
            Activator.LOG.warning("Cannot store bundleLocationToFeature.properties Persistence not supported by this framework.");
            return;
        }
        Properties p = new Properties();
        for (Map.Entry entry : this.bundleLocationConfigMap.entrySet()) {
            p.setProperty((String)entry.getKey(), (String)((Map.Entry)entry.getValue()).getKey() + "~" + ((Map.Entry)entry.getValue()).getValue());
        }
        if (p.size() > 0) {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                p.store(os, "Bundle Location to Feature Map");
            }
            catch (IOException e) {
                Activator.LOG.log(Level.WARNING, "Unable to store bundleLocationToFeature.properties", e);
            }
        }
    }

    private synchronized void updateConfiguration() {
        Map<Map.Entry<String, Version>, List<String>> bvm = RegionConfiguration.cloneMapOfLists(this.baseBsnVerMap);
        Map<String, Set<String>> bfm = RegionConfiguration.cloneMapOfSets(this.baseBundleFeatureMap);
        Map<String, List<String>> frm = RegionConfiguration.cloneMapOfLists(this.baseFeatureRegionMap);
        Map<String, Set<String>> rpm = RegionConfiguration.cloneMapOfSets(this.baseRegionPackageMap);
        for (Dictionary<String, Object> props : this.factoryConfigs.values()) {
            Object valObj = props.get("mapping.bundleid.bsnver");
            if (valObj != null) {
                for (String val : this.convert(valObj)) {
                    String[] parts = val.split("=");
                    String n = parts[0];
                    String[] bsnver = parts[1].split("~");
                    String bsn = bsnver[0];
                    String bver = bsnver[1];
                    RegionConfiguration.addBsnVerArtifact(bvm, bsn, bver, n);
                }
            }
            if ((valObj = props.get("mapping.bundleid.features")) != null) {
                this.handleMapConfig(valObj, bfm, HashSet::new);
            }
            if ((valObj = props.get("mapping.featureid.regions")) != null) {
                this.handleMapConfig(valObj, frm, ArrayList::new);
            }
            if ((valObj = props.get("mapping.region.packages")) == null) continue;
            this.handleMapConfig(valObj, rpm, HashSet::new);
        }
        if (this.toGlobalConfig != null) {
            this.joinRegionsWithGlobal(this.toGlobalConfig, rpm);
        }
        this.bsnVerMap = RegionConfiguration.unmodifiableMapToList(bvm);
        this.bundleFeatureMap = RegionConfiguration.unmodifiableMapToSet(bfm);
        this.featureRegionMap = RegionConfiguration.unmodifiableMapToList(frm);
        this.regionPackageMap = RegionConfiguration.unmodifiableMapToSet(rpm);
    }

    private <T extends Collection<String>> void handleMapConfig(Object valObj, Map<String, T> map, Supplier<T> constructor) {
        for (String val : this.convert(valObj)) {
            String[] parts = val.split("=");
            String n = parts[0];
            List<String> features = parts.length == 1 ? Collections.emptyList() : Arrays.asList(parts[1].split(","));
            RegionConfiguration.addValuesToMap(map, n, features, constructor);
        }
    }

    private static <K, V> Map<K, List<V>> cloneMapOfLists(Map<K, List<V>> m) {
        HashMap newMap = new HashMap();
        for (Map.Entry<K, List<V>> entry : m.entrySet()) {
            newMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return newMap;
    }

    private static <K, V> Map<K, Set<V>> cloneMapOfSets(Map<K, Set<V>> m) {
        HashMap newMap = new HashMap();
        for (Map.Entry<K, Set<V>> entry : m.entrySet()) {
            newMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return newMap;
    }

    private static <K, V> Map<K, List<V>> unmodifiableMapToList(Map<K, List<V>> m) {
        for (Map.Entry<K, List<V>> entry : m.entrySet()) {
            m.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    private static <K, V> Map<K, Set<V>> unmodifiableMapToSet(Map<K, Set<V>> m) {
        for (Map.Entry<K, Set<V>> entry : m.entrySet()) {
            m.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    private void joinRegionsWithGlobal(String toglobal, Map<String, Set<String>> rpm) {
        for (String region : toglobal.split(",")) {
            Set<String> packages = rpm.get(region);
            if (packages == null) continue;
            RegionConfiguration.addValuesToMap(rpm, "global", packages, HashSet::new);
            rpm.remove(region);
        }
    }

    private static Map<Map.Entry<String, Version>, List<String>> populateBSNVerMap(URI idbsnverFile) throws IOException {
        HashMap<Map.Entry<String, Version>, List<String>> m = new HashMap<Map.Entry<String, Version>, List<String>>();
        Properties p = new Properties();
        try (InputStream is = idbsnverFile.toURL().openStream();){
            p.load(is);
        }
        for (String n : p.stringPropertyNames()) {
            String[] bsnver = p.getProperty(n).split("~");
            RegionConfiguration.addBsnVerArtifact(m, bsnver[0], bsnver[1], n);
        }
        return m;
    }

    private static void addBsnVerArtifact(Map<Map.Entry<String, Version>, List<String>> bsnVerMap, String bundleSymbolicName, String bundleVersion, String artifactId) {
        Version version = Version.valueOf((String)bundleVersion);
        AbstractMap.SimpleEntry<String, Version> bsnVer = new AbstractMap.SimpleEntry<String, Version>(bundleSymbolicName, version);
        List<String> l = bsnVerMap.get(bsnVer);
        if (l == null) {
            l = new ArrayList<String>();
            bsnVerMap.put(bsnVer, l);
        }
        if (!l.contains(artifactId)) {
            l.add(artifactId);
        }
    }

    private static Map<String, Set<String>> populateBundleFeatureMap(URI bundlesFile) throws IOException {
        return RegionConfiguration.loadMap(bundlesFile, HashSet::new);
    }

    private static Map<String, List<String>> populateFeatureRegionMap(URI featuresFile) throws IOException {
        return RegionConfiguration.loadMap(featuresFile, ArrayList::new);
    }

    private static Map<String, Set<String>> populateRegionPackageMap(URI regionsFile) throws IOException {
        return RegionConfiguration.loadMap(regionsFile, HashSet::new);
    }

    private static <T extends Collection<String>> Map<String, T> loadMap(URI propsFile, Supplier<T> constructor) throws IOException {
        HashMap m = new HashMap();
        Properties p = new Properties();
        try (InputStream is = propsFile.toURL().openStream();){
            p.load(is);
        }
        for (String n : p.stringPropertyNames()) {
            String[] values = p.getProperty(n).split(",");
            RegionConfiguration.addValuesToMap(m, n, Arrays.asList(values), constructor);
        }
        return m;
    }

    private static <T extends Collection<String>> void addValuesToMap(Map<String, T> map, String key, Collection<String> values, Supplier<T> constructor) {
        Collection bf = (Collection)map.get(key);
        if (bf == null) {
            bf = (Collection)constructor.get();
            map.put(key, bf);
        }
        bf.addAll(values);
    }

    private URI getDataFileURI(BundleContext ctx, String name) throws IOException, URISyntaxException {
        String loc;
        String fn = ctx.getProperty("sling.feature.apiregions.resource." + name);
        if (fn == null && (loc = ctx.getProperty("sling.feature.apiregions.location")) != null) {
            fn = loc + "/" + name;
        }
        if (fn == null) {
            throw new IOException("API Region Enforcement enabled, but no configuration found to find region definition resource: " + name);
        }
        if (fn.contains(":")) {
            if (fn.startsWith("classloader://")) {
                loc = fn.substring("classloader://".length());
                if (!loc.startsWith("/")) {
                    loc = "/" + loc;
                }
                fn = this.getClass().getResource(loc).toString();
            }
            return new URI(fn);
        }
        return new File(fn).toURI();
    }

    public Map<Map.Entry<String, Version>, List<String>> getBsnVerMap() {
        return this.bsnVerMap;
    }

    public ConcurrentMap<String, Map.Entry<String, Version>> getBundleLocationConfigMap() {
        return this.bundleLocationConfigMap;
    }

    public Map<String, Set<String>> getBundleFeatureMap() {
        return this.bundleFeatureMap;
    }

    public Map<String, List<String>> getFeatureRegionMap() {
        return this.featureRegionMap;
    }

    public Map<String, Set<String>> getRegionPackageMap() {
        return this.regionPackageMap;
    }

    public Set<String> getDefaultRegions() {
        return this.defaultRegions;
    }

    public List<String> getGlobalRegionOrder() {
        return this.globalRegionOrder;
    }

    public Dictionary<String, Object> getRegistrationProperties() {
        return this.regProps;
    }

    private String[] convert(Object obj) {
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        return new String[]{obj.toString()};
    }

    public void setConfig(String pid, Dictionary<String, Object> props) {
        this.factoryConfigs.put(pid, props);
        this.updateConfiguration();
    }

    public void removeConfig(String pid) {
        Dictionary<String, Object> props = this.factoryConfigs.remove(pid);
        if (props != null) {
            this.updateConfiguration();
        }
    }
}

