/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.sling.distribution.journal.impl.subscriber.IdleCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberReady
implements IdleCheck {
    public static final long ACCEPTABLE_AGE_DIFF_MS = TimeUnit.MINUTES.toMillis(2L);
    public static final int MAX_RETRIES = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String subAgentName;
    private final long idleMillis;
    private final AtomicBoolean isReady;
    private final Supplier<Long> timeProvider;
    private final ScheduledExecutorService executor;
    private final long forceIdleMillies;
    private final long startTime;
    private ScheduledFuture<?> schedule;
    private final ScheduledFuture<?> forceShedule;

    public SubscriberReady(String subAgentName, long idleMillis, long forceIdleMillies, AtomicBoolean readyHolder, Supplier<Long> timeProvider) {
        this.subAgentName = subAgentName;
        this.idleMillis = idleMillis;
        this.forceIdleMillies = forceIdleMillies;
        this.isReady = readyHolder;
        this.timeProvider = timeProvider;
        this.startTime = timeProvider.get();
        this.executor = Executors.newScheduledThreadPool(2);
        this.forceShedule = this.executor.schedule(this::forceIdle, forceIdleMillies, TimeUnit.MILLISECONDS);
        this.idle();
        this.log.info("Started");
    }

    @Override
    public boolean isReady() {
        return this.isReady.get();
    }

    @Override
    public synchronized void busy(int retries, long messageCreateTime) {
        if (this.isReady()) {
            return;
        }
        this.cancelSchedule();
        long latency = this.timeProvider.get() - messageCreateTime;
        if (latency < ACCEPTABLE_AGE_DIFF_MS) {
            this.ready(String.format("Package message latency %d s < %d s acceptable limit", TimeUnit.MILLISECONDS.toSeconds(latency), TimeUnit.MILLISECONDS.toSeconds(ACCEPTABLE_AGE_DIFF_MS)));
        }
        if (retries > 10) {
            this.ready(String.format("Retries %d > %d", retries, 10));
        }
    }

    @Override
    public synchronized void idle() {
        if (this.isReady()) {
            return;
        }
        this.cancelSchedule();
        if (!this.executor.isShutdown()) {
            this.schedule = this.executor.schedule(this::idleReady, this.idleMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void forceIdle() {
        this.ready(String.format("Forcing ready after %d s", TimeUnit.MILLISECONDS.toSeconds(this.forceIdleMillies)));
        this.cancelSchedule();
    }

    private void cancelSchedule() {
        if (this.schedule != null) {
            this.schedule.cancel(false);
        }
    }

    private void idleReady() {
        this.ready(String.format("%s ready after being idle for > %d ms", this.subAgentName, TimeUnit.MILLISECONDS.toSeconds(this.idleMillis)));
    }

    private void ready(String reason) {
        long readyTime = this.timeProvider.get();
        long timeToIdle = TimeUnit.MILLISECONDS.toSeconds(readyTime - this.startTime);
        this.log.info("Subscriber becoming ready after timeToIdle={} s. Reason='{}'", (Object)timeToIdle, (Object)reason);
        this.isReady.set(true);
        this.cancelSchedule();
        this.forceShedule.cancel(false);
    }

    @Override
    public void close() {
        this.forceShedule.cancel(false);
        this.cancelSchedule();
        this.executor.shutdownNow();
    }
}

