/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.rrd4j.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;

class CopyMetricRegistryListener
implements MetricRegistryListener {
    private final MetricRegistry parent;
    private final String name;

    CopyMetricRegistryListener(MetricRegistry parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    void start(MetricRegistry metricRegistry) {
        metricRegistry.addListener((MetricRegistryListener)this);
    }

    void stop(MetricRegistry metricRegistry) {
        metricRegistry.removeListener((MetricRegistryListener)this);
        for (String name : metricRegistry.getMetrics().keySet()) {
            this.removeMetric(name);
        }
    }

    private void addMetric(String metricName, Metric m) {
        this.parent.register(this.getMetricName(metricName), m);
    }

    private void removeMetric(String metricName) {
        this.parent.remove(this.getMetricName(metricName));
    }

    private String getMetricName(String metricName) {
        return this.name + "_" + metricName;
    }

    public void onGaugeAdded(String s, Gauge<?> gauge) {
        this.addMetric(s, (Metric)gauge);
    }

    public void onGaugeRemoved(String s) {
        this.removeMetric(s);
    }

    public void onCounterAdded(String s, Counter counter) {
        this.addMetric(s, (Metric)counter);
    }

    public void onCounterRemoved(String s) {
        this.removeMetric(s);
    }

    public void onHistogramAdded(String s, Histogram histogram) {
        this.addMetric(s, (Metric)histogram);
    }

    public void onHistogramRemoved(String s) {
        this.removeMetric(s);
    }

    public void onMeterAdded(String s, Meter meter) {
        this.addMetric(s, (Metric)meter);
    }

    public void onMeterRemoved(String s) {
        this.removeMetric(s);
    }

    public void onTimerAdded(String s, Timer timer) {
        this.addMetric(s, (Metric)timer);
    }

    public void onTimerRemoved(String s) {
        this.removeMetric(s);
    }
}

