/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.bgservlets.ExecutionEngine;
import org.apache.sling.bgservlets.JobStatus;
import org.apache.sling.bgservlets.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%ExecutionEngineImpl.label", description="%ExecutionEngineImpl.description")
@Service
public class ExecutionEngineImpl
implements ExecutionEngine {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Executor executor;
    private final Map<String, JobStatus> jobs = Collections.synchronizedMap(new HashMap());
    @Property(intValue={10})
    public static final String PROP_CORE_POOL_SIZE = "core.pool.size";
    private int corePoolSize;
    @Property(intValue={20})
    public static final String PROP_MAX_POOL_SIZE = "max.pool.size";
    private int maximumPoolSize;
    @Property(intValue={30})
    public static final String PROP_KEEP_ALIVE_TIME = "keep.alive.time.seconds";
    private int keepAliveTimeSeconds;

    private int getIntegerProperty(Map<String, Object> props, String name) {
        Integer value = (Integer)props.get(name);
        if (value == null) {
            throw new IllegalStateException("Missing ComponentContext property: " + name);
        }
        return value;
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        this.corePoolSize = this.getIntegerProperty(props, PROP_CORE_POOL_SIZE);
        this.maximumPoolSize = this.getIntegerProperty(props, PROP_MAX_POOL_SIZE);
        this.keepAliveTimeSeconds = this.getIntegerProperty(props, PROP_KEEP_ALIVE_TIME);
        TimeUnit unit = TimeUnit.SECONDS;
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(4);
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                ExecutionEngineImpl.this.onJobRejected(r);
            }
        };
        this.log.info("ThreadPoolExecutor configuration: corePoolSize = {}, maxPoolSize={}, keepAliveTimeSeconds={}", new Object[]{this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds});
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTimeSeconds, unit, workQueue, handler);
    }

    @Deactivate
    protected void deactivate() {
        this.executor = null;
    }

    private void onJobRejected(Runnable r) {
        RunnableWrapper w = (RunnableWrapper)r;
        if (w.getJobStatus() != null) {
            w.getJobStatus().requestStateChange(JobStatus.State.REJECTED);
        }
        this.log.info("Rejected job {}", (Object)r);
        throw new QueueFullException(r);
    }

    @Override
    public void queueForExecution(Runnable inputJob) {
        RunnableWrapper w = new RunnableWrapper(inputJob);
        if (w.getJobStatus() != null) {
            w.getJobStatus().requestStateChange(JobStatus.State.QUEUED);
            this.jobs.put(w.getJobStatus().getPath(), w.getJobStatus());
        }
        this.executor.execute(w);
    }

    @Override
    public JobStatus getJobStatus(String path) {
        return this.jobs.get(path);
    }

    @Override
    public Iterator<JobStatus> getMatchingJobStatus(Predicate<JobStatus> p) {
        return this.jobs.values().iterator();
    }

    public static class QueueFullException
    extends SlingException {
        QueueFullException(Runnable r) {
            super("Execution queue is full, cannot execute " + r);
        }
    }

    private class RunnableWrapper
    implements Runnable {
        private final Runnable inputJob;
        private final JobStatus jobStatus;

        RunnableWrapper(Runnable inputJob) {
            this.inputJob = inputJob;
            this.jobStatus = inputJob instanceof JobStatus ? (JobStatus)((Object)inputJob) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.jobStatus != null) {
                this.jobStatus.requestStateChange(JobStatus.State.RUNNING);
            }
            ExecutionEngineImpl.this.log.info("Starting job {}", (Object)this.inputJob);
            try {
                this.inputJob.run();
            }
            finally {
                if (this.jobStatus != null) {
                    ExecutionEngineImpl.this.log.debug("Job is done, cleaning up {}", (Object)this.jobStatus.getPath());
                    this.jobStatus.requestStateChange(JobStatus.State.DONE);
                    ExecutionEngineImpl.this.jobs.remove(this.jobStatus.getPath());
                }
            }
            ExecutionEngineImpl.this.log.info("Done running job {}", (Object)this.inputJob);
        }

        JobStatus getJobStatus() {
            return this.jobStatus;
        }
    }
}

