/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.internal.shared.BandAggregateArgument;
import org.apache.sis.coverage.internal.shared.SampleDimensions;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandAggregateImage;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.util.collection.FrequencySortedSet;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;

final class BandAggregateLayout {
    private final RenderedImage[] sources;
    final RenderedImage[] filteredSources;
    private final int[][] bandsPerSource;
    final int[] bandSelect;
    final BandedSampleModel sampleModel;
    final Rectangle domain;
    final Point minTile;
    final List<SampleDimension> sampleDimensions;
    final boolean allowSharing;

    BandAggregateLayout(RenderedImage[] sources, int[][] bandsPerSource, boolean allowSharing) {
        boolean exactTileSize;
        this.allowSharing = allowSharing;
        BandAggregateArgument<RenderedImage> aggregate = new BandAggregateArgument<RenderedImage>(sources, bandsPerSource);
        aggregate.unwrap(BandAggregateImage::unwrap);
        aggregate.validate(ImageUtilities::getNumBands);
        this.bandSelect = aggregate.mergeDuplicatedSources();
        sources = aggregate.sources();
        bandsPerSource = aggregate.bandsPerSource(true);
        int numBands = aggregate.numBands();
        Rectangle domain = null;
        int scanlineStride = 0;
        int tileWidth = 0;
        int tileHeight = 0;
        int tileAlignX = 0;
        int tileAlignY = 0;
        DataType commonDataType = null;
        for (RenderedImage source : sources) {
            ComponentSampleModel csm;
            SampleModel sm = source.getSampleModel();
            if (allowSharing && (allowSharing = sm instanceof ComponentSampleModel) && (allowSharing = (csm = (ComponentSampleModel)sm).getPixelStride() == 1)) {
                allowSharing &= scanlineStride == (scanlineStride = csm.getScanlineStride());
                int n = tileWidth;
                tileWidth = source.getTileWidth();
                allowSharing &= n == tileWidth;
                int n2 = tileHeight;
                tileHeight = source.getTileHeight();
                allowSharing &= n2 == tileHeight;
                int n3 = tileAlignX;
                tileAlignX = Math.floorMod(source.getTileGridXOffset(), tileWidth);
                allowSharing &= n3 == tileAlignX;
                int n4 = tileAlignY;
                tileAlignY = Math.floorMod(source.getTileGridYOffset(), tileHeight);
                allowSharing &= n4 == tileAlignY;
                allowSharing |= domain == null;
            }
            DataType dataType = DataType.forBands(sm);
            if (domain == null) {
                domain = ImageUtilities.getBounds(source);
                commonDataType = dataType;
                continue;
            }
            if (dataType != commonDataType) {
                throw new IllegalArgumentException(Resources.format((short)42));
            }
            ImageUtilities.clipBounds(source, domain);
            if (!domain.isEmpty()) continue;
            throw new DisjointExtentException(Resources.format((short)80));
        }
        this.domain = domain;
        if (domain == null) {
            throw new IllegalArgumentException(Resources.format((short)81));
        }
        long cy = 9223372032559808768L;
        long cx = 9223372032559808768L;
        FrequencySortedSet tileGridXOffset = new FrequencySortedSet(true);
        FrequencySortedSet tileGridYOffset = new FrequencySortedSet(true);
        for (RenderedImage source : sources) {
            cx = BandAggregateLayout.chooseTileSize(cx, source.getTileWidth(), domain.width, domain.x - source.getMinX());
            cy = BandAggregateLayout.chooseTileSize(cy, source.getTileHeight(), domain.height, domain.y - source.getMinY());
            tileGridXOffset.add((Object)source.getTileGridXOffset());
            tileGridYOffset.add((Object)source.getTileGridYOffset());
        }
        Dimension preferredTileSize = new Dimension((int)cx, (int)cy);
        this.minTile = new Point(BandAggregateLayout.chooseMinTile((FrequencySortedSet<Integer>)tileGridXOffset, domain.x, preferredTileSize.width), BandAggregateLayout.chooseMinTile((FrequencySortedSet<Integer>)tileGridYOffset, domain.y, preferredTileSize.height));
        boolean bl = exactTileSize = (cx | cy) >>> 32 == 0L;
        if (!(allowSharing &= exactTileSize)) {
            scanlineStride = 0;
        }
        ImageLayout layout = new ImageLayout(null, preferredTileSize, !exactTileSize, false, false, this.minTile);
        this.sampleModel = layout.createBandedSampleModel(null, domain, commonDataType, numBands, scanlineStride);
        this.bandsPerSource = bandsPerSource;
        this.sources = sources;
        this.filteredSources = new RenderedImage[sources.length];
        for (int i = 0; i < this.filteredSources.length; ++i) {
            RenderedImage source = sources[i];
            int[] bands = bandsPerSource[i];
            if (bands != null) {
                source = BandSelectImage.create(source, true, bands);
            }
            this.filteredSources[i] = source;
        }
        this.sampleDimensions = this.getSampleDimensions();
    }

    private static long chooseTileSize(long current, int tileSize, int imageSize, int offset) {
        if (imageSize % tileSize == 0) {
            long c = Math.floorMod(offset, tileSize);
            c <<= 32;
            if (Long.compareUnsigned(c |= (long)tileSize, current) < 0) {
                return c;
            }
        }
        return current;
    }

    private static int chooseMinTile(FrequencySortedSet<Integer> offsets, int min, int tileSize) {
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            if ((offset = min - offset) % tileSize != 0) continue;
            return offset / tileSize;
        }
        return 0;
    }

    final boolean isWritable() {
        for (RenderedImage source : this.filteredSources) {
            if (source instanceof WritableRenderedImage) continue;
            return false;
        }
        return true;
    }

    final ColorModel createColorModel(Colorizer colorizer) {
        Colorizer.Target target;
        Optional<ColorModel> candidate;
        ColorModel colors = null;
        int visibleBand = 0;
        int base = 0;
        block0: for (int i = 0; i < this.sources.length; ++i) {
            RenderedImage source = this.sources[i];
            int[] bands = this.bandsPerSource[i];
            int vb = ImageUtilities.getVisibleBand(source);
            if (vb >= 0) {
                if (bands == null) {
                    visibleBand = base + vb;
                    colors = source.getColorModel();
                    break;
                }
                for (int j = 0; j < bands.length; ++j) {
                    if (bands[j] != vb) continue;
                    visibleBand = base + j;
                    colors = source.getColorModel();
                    break block0;
                }
            }
            base += bands != null ? bands.length : ImageUtilities.getNumBands(source);
        }
        if (colorizer != null && (candidate = colorizer.apply(target = new Colorizer.Target(this.sampleModel, this.sampleDimensions, visibleBand))).isPresent()) {
            return candidate.get();
        }
        if ((colors = ColorModelFactory.derive(colors, this.sampleModel.getNumBands(), visibleBand)) != null) {
            return colors;
        }
        return ColorModelFactory.createGrayScale(this.sampleModel, visibleBand, null);
    }

    private List<SampleDimension> getSampleDimensions() {
        List<SampleDimension> ranges = SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.get();
        if (ranges != null) {
            return ranges;
        }
        int offset = 0;
        Object[] result = new SampleDimension[this.bandSelect.length];
        for (RenderedImage source : this.filteredSources) {
            Object value = source.getProperty("org.apache.sis.SampleDimensions");
            if (value instanceof SampleDimension[]) {
                SampleDimension[] sd = (SampleDimension[])value;
                int n = ImageUtilities.getNumBands(source);
                System.arraycopy(sd, 0, result, offset, Math.min(sd.length, n));
                offset += n;
                continue;
            }
            return null;
        }
        return UnmodifiableArrayList.wrap((Object[])result);
    }
}

