/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.storage.BundleInfo;

public class ManifestLocalization {
    final String defaultRoot;
    private final BundleInfo.Generation generation;
    private final Dictionary<String, String> rawHeaders;
    private volatile Dictionary<String, String> defaultLocaleHeaders = null;
    private final Hashtable<String, BundleResourceBundle> cache = new Hashtable(5);

    public ManifestLocalization(BundleInfo.Generation generation, Dictionary<String, String> rawHeaders, String defaultRoot) {
        this.generation = generation;
        this.rawHeaders = rawHeaders;
        this.defaultRoot = defaultRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Hashtable<String, BundleResourceBundle> hashtable = this.cache;
        synchronized (hashtable) {
            this.cache.clear();
            this.defaultLocaleHeaders = null;
        }
    }

    Dictionary<String, String> getHeaders(String localeString) {
        if (localeString == null) {
            localeString = Locale.getDefault().toString();
        }
        if (localeString.length() == 0) {
            return this.rawHeaders;
        }
        boolean isDefaultLocale = localeString.equals(Locale.getDefault().toString());
        Dictionary<String, String> currentDefault = this.defaultLocaleHeaders;
        if (isDefaultLocale && currentDefault != null) {
            return currentDefault;
        }
        if (this.generation.getRevision().getRevisions().getModule().getState().equals((Object)Module.State.UNINSTALLED)) {
            if (currentDefault != null) {
                return currentDefault;
            }
            return this.rawHeaders;
        }
        ResourceBundle localeProperties = this.getResourceBundle(localeString, isDefaultLocale);
        Enumeration<String> eKeys = this.rawHeaders.keys();
        Headers<String, String> localeHeaders = new Headers<String, String>(this.rawHeaders.size());
        while (eKeys.hasMoreElements()) {
            String key = eKeys.nextElement();
            String value = this.rawHeaders.get(key);
            if (value.startsWith("%") && value.length() > 1) {
                String propertiesKey = value.substring(1);
                try {
                    value = localeProperties == null ? propertiesKey : (String)localeProperties.getObject(propertiesKey);
                }
                catch (MissingResourceException missingResourceException) {
                    value = propertiesKey;
                }
            }
            localeHeaders.set(key, value);
        }
        localeHeaders.setReadOnly();
        if (isDefaultLocale) {
            this.defaultLocaleHeaders = localeHeaders;
        }
        return localeHeaders;
    }

    private String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        while (nl.length() > 0) {
            result.add(nl);
            int i = nl.lastIndexOf(95);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    ResourceBundle getResourceBundle(String localeString, boolean isDefaultLocale) {
        BundleResourceBundle resourceBundle = this.lookupResourceBundle(localeString);
        if (isDefaultLocale) {
            return (ResourceBundle)((Object)resourceBundle);
        }
        if (resourceBundle == null || resourceBundle.isStemEmpty()) {
            return (ResourceBundle)((Object)this.lookupResourceBundle(Locale.getDefault().toString()));
        }
        return (ResourceBundle)((Object)resourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleResourceBundle lookupResourceBundle(String localeString) {
        BundleResourceBundle result;
        String localizationHeader = this.rawHeaders.get("Bundle-Localization");
        if (localizationHeader == null) {
            localizationHeader = "OSGI-INF/l10n/bundle";
        }
        if ((result = this.cache.get(localeString)) != null) {
            return result.isEmpty() ? null : result;
        }
        String[] nlVarients = this.buildNLVariants(localeString);
        InputStream[] nlStreams = new InputStream[nlVarients.length];
        int i = nlVarients.length - 1;
        while (i >= 0) {
            URL url = this.findResource(String.valueOf(localizationHeader) + (nlVarients[i].equals("") ? nlVarients[i] : String.valueOf('_') + nlVarients[i]) + ".properties");
            if (url != null) {
                try {
                    nlStreams[i] = url.openStream();
                }
                catch (IOException iOException) {}
            }
            --i;
        }
        Hashtable<String, BundleResourceBundle> hashtable = this.cache;
        synchronized (hashtable) {
            BundleResourceBundle parent = null;
            int i2 = nlVarients.length - 1;
            while (i2 >= 0) {
                BundleResourceBundle varientBundle;
                block28: {
                    varientBundle = null;
                    InputStream varientStream = nlStreams[i2];
                    if (varientStream == null) {
                        varientBundle = this.cache.get(nlVarients[i2]);
                    } else {
                        try {
                            try {
                                varientBundle = new LocalizationResourceBundle(varientStream);
                            }
                            catch (IOException iOException) {
                                if (varientStream != null) {
                                    try {
                                        varientStream.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            if (varientStream != null) {
                                try {
                                    varientStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (varientStream != null) {
                            try {
                                varientStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (varientBundle == null) {
                    varientBundle = new EmptyResouceBundle(nlVarients[i2]);
                }
                if (parent != null) {
                    varientBundle.setParent((ResourceBundle)((Object)parent));
                }
                this.cache.put(nlVarients[i2], varientBundle);
                parent = varientBundle;
                --i2;
            }
            result = this.cache.get(localeString);
            BundleResourceBundle bundleResourceBundle = result.isEmpty() ? null : result;
            return bundleResourceBundle;
        }
    }

    private URL findResource(String resource) {
        ModuleWiring searchWiring = this.generation.getRevision().getWiring();
        if (searchWiring != null && (this.generation.getRevision().getTypes() & 1) != 0) {
            List<ModuleWire> hostWires = searchWiring.getRequiredModuleWires("osgi.wiring.host");
            searchWiring = null;
            Long lowestHost = Long.MAX_VALUE;
            if (hostWires != null) {
                for (ModuleWire hostWire : hostWires) {
                    Long hostID = hostWire.getProvider().getRevisions().getModule().getId();
                    if (hostID.compareTo(lowestHost) > 0) continue;
                    lowestHost = hostID;
                    searchWiring = hostWire.getProviderWiring();
                }
            }
        }
        if (searchWiring != null) {
            int lastSlash = resource.lastIndexOf(47);
            String path = lastSlash > 0 ? resource.substring(0, lastSlash) : "/";
            String fileName = lastSlash != -1 ? resource.substring(lastSlash + 1) : resource;
            List<URL> result = searchWiring.findEntries(path, fileName, 0);
            return result == null || result.isEmpty() ? null : result.get(0);
        }
        return this.generation.getEntry(resource);
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();

        public boolean isStemEmpty();
    }

    class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private final String localeString;

        public EmptyResouceBundle(String locale) {
            this.localeString = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Override
        protected Object handleGetObject(String arg0) throws MissingResourceException {
            return null;
        }

        @Override
        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        @Override
        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }

        @Override
        public boolean isStemEmpty() {
            if (ManifestLocalization.this.defaultRoot.equals(this.localeString)) {
                return false;
            }
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isStemEmpty();
        }
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isStemEmpty() {
            return this.parent == null;
        }
    }
}

