/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class RestComponent
extends UriEndpointComponent {
    public RestComponent() {
        super(RestEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String uriTemplate;
        String path;
        RestEndpoint answer = new RestEndpoint(uri, this);
        this.setProperties(answer, parameters);
        answer.setParameters(parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be rest:method:path[:uriTemplate] where uriTemplate is optional");
        }
        String method = ObjectHelper.before(remaining, ":");
        String s = ObjectHelper.after(remaining, ":");
        if (s != null && s.contains(":")) {
            path = ObjectHelper.before(s, ":");
            uriTemplate = ObjectHelper.after(s, ":");
        } else {
            path = s;
            uriTemplate = null;
        }
        path = FileUtil.stripTrailingSeparator(path);
        uriTemplate = FileUtil.stripTrailingSeparator(uriTemplate);
        answer.setMethod(method);
        answer.setPath(path);
        answer.setUriTemplate(uriTemplate);
        if (answer.getComponentName() == null && this.getCamelContext().getRestConfiguration() != null) {
            answer.setComponentName(this.getCamelContext().getRestConfiguration().getComponent());
        }
        return answer;
    }
}

