/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.util;

import java.util.Dictionary;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.ObjectUtils;

public abstract class OsgiServiceBindingUtils {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceBindingUtils.class);

    public static void callListenersBind(BundleContext context, Object serviceProxy, ServiceReference reference, OsgiServiceLifecycleListener[] listeners) {
        if (!ObjectUtils.isEmpty((Object[])listeners)) {
            boolean debug = log.isDebugEnabled();
            Dictionary properties = OsgiServiceReferenceUtils.getServicePropertiesSnapshot(reference);
            for (int i = 0; i < listeners.length; ++i) {
                if (debug) {
                    log.debug((Object)("Calling bind on " + listeners[i] + " w/ reference " + reference));
                }
                try {
                    listeners[i].bind(serviceProxy, (Map)((Object)properties));
                }
                catch (Exception ex) {
                    log.warn((Object)("Bind method on listener " + listeners[i] + " threw exception "), (Throwable)ex);
                }
                if (!debug) continue;
                log.debug((Object)("Called bind on " + listeners[i] + " w/ reference " + reference));
            }
        }
    }

    public static void callListenersUnbind(BundleContext context, Object serviceProxy, ServiceReference reference, OsgiServiceLifecycleListener[] listeners) {
        if (!ObjectUtils.isEmpty((Object[])listeners)) {
            boolean debug = log.isDebugEnabled();
            Dictionary properties = OsgiServiceReferenceUtils.getServicePropertiesSnapshot(reference);
            for (int i = 0; i < listeners.length; ++i) {
                if (debug) {
                    log.debug((Object)("Calling unbind on " + listeners[i] + " w/ reference " + reference));
                }
                try {
                    listeners[i].unbind(serviceProxy, (Map)((Object)properties));
                }
                catch (Exception ex) {
                    log.warn((Object)("Unbind method on listener " + listeners[i] + " threw exception "), (Throwable)ex);
                }
                if (!debug) continue;
                log.debug((Object)("Called unbind on " + listeners[i] + " w/ reference " + reference));
            }
        }
    }
}

