/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.File;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.usage.PercentLimitUsage;
import org.apache.activemq.util.StoreUtil;

public class TempUsage
extends PercentLimitUsage<TempUsage> {
    private PListStore store;

    public TempUsage() {
        super(null, null, 1.0f);
    }

    public TempUsage(String name, PListStore store2) {
        super(null, name, 1.0f);
        this.store = store2;
        this.updateLimitBasedOnPercent();
    }

    public TempUsage(TempUsage parent, String name) {
        super(parent, name, 1.0f);
        this.store = parent.store;
        this.updateLimitBasedOnPercent();
    }

    @Override
    protected long retrieveUsage() {
        if (this.store == null) {
            return 0L;
        }
        return this.store.size();
    }

    public PListStore getStore() {
        return this.store;
    }

    public void setStore(PListStore store2) {
        this.store = store2;
        if (this.percentLimit > 0 && store2 != null) {
            this.updateLimitBasedOnPercent();
        } else {
            this.onLimitChange();
        }
    }

    @Override
    protected void updateLimitBasedOnPercent() {
        this.usageLock.writeLock().lock();
        try {
            File dir;
            if (this.percentLimit > 0 && this.store != null && (dir = StoreUtil.findParentDirectory(this.store.getDirectory())) != null) {
                this.setLimit(dir.getTotalSpace() * (long)this.percentLimit / 100L);
            }
        }
        finally {
            this.usageLock.writeLock().unlock();
        }
    }
}

