/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.PacketData;

public final class Location
implements RecordLocation {
    public static final int SERIALIZED_SIZE = 8;
    private final int logFileId;
    private final int logFileOffset;

    public Location(int logFileId, int fileOffset) {
        this.logFileId = logFileId;
        this.logFileOffset = fileOffset;
    }

    public int compareTo(Object o) {
        int rc = this.logFileId - ((Location)o).logFileId;
        if (rc != 0) {
            return rc;
        }
        return this.logFileOffset - ((Location)o).logFileOffset;
    }

    public int hashCode() {
        return this.logFileOffset ^ this.logFileId;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != Location.class) {
            return false;
        }
        Location rl = (Location)o;
        return rl.logFileId == this.logFileId && rl.logFileOffset == this.logFileOffset;
    }

    public String toString() {
        return "" + this.logFileId + ":" + this.logFileOffset;
    }

    public int getLogFileId() {
        return this.logFileId;
    }

    public int getLogFileOffset() {
        return this.logFileOffset;
    }

    public void writeToPacket(Packet packet) throws IOException {
        PacketData data = new PacketData(packet);
        data.writeInt(this.logFileId);
        data.writeInt(this.logFileOffset);
    }

    public void writeToDataOutput(DataOutput data) throws IOException {
        data.writeInt(this.logFileId);
        data.writeInt(this.logFileOffset);
    }

    public static Location readFromPacket(Packet packet) throws IOException {
        PacketData data = new PacketData(packet);
        return new Location(data.readInt(), data.readInt());
    }

    public static Location readFromDataInput(DataInput data) throws IOException {
        return new Location(data.readInt(), data.readInt());
    }
}

