/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.serviceregistry.client.http.AbstractClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebsocketClientPool
extends AbstractClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketClientPool.class);
    public static final WebsocketClientPool INSTANCE = new WebsocketClientPool();

    private WebsocketClientPool() {
    }

    @Override
    protected boolean isWorker() {
        return true;
    }

    @Override
    public HttpClientOptions createHttpClientOptions() {
        HttpVersion ver = ServiceRegistryConfig.INSTANCE.getHttpVersion();
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setProtocolVersion(ver);
        httpClientOptions.setConnectTimeout(ServiceRegistryConfig.INSTANCE.getConnectionTimeout());
        httpClientOptions.setIdleTimeout(ServiceRegistryConfig.INSTANCE.getIdleWatchTimeout());
        if (ver == HttpVersion.HTTP_2) {
            LOGGER.debug("service center ws client protocol version is HTTP/2");
            httpClientOptions.setHttp2ClearTextUpgrade(false);
        }
        if (ServiceRegistryConfig.INSTANCE.isSsl()) {
            LOGGER.debug("service center ws client performs requests over TLS");
            VertxTLSBuilder.buildHttpClientOptions((String)"sc.consumer", (HttpClientOptions)httpClientOptions);
        }
        return httpClientOptions;
    }
}

