/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

public class ThreadLocalCurrentTraceContext
extends CurrentTraceContext {
    static final ThreadLocal<TraceContext> DEFAULT = new ThreadLocal();
    final ThreadLocal<TraceContext> local;

    public static CurrentTraceContext create() {
        return new Builder().build();
    }

    public static CurrentTraceContext.Builder newBuilder() {
        return new Builder();
    }

    ThreadLocalCurrentTraceContext(CurrentTraceContext.Builder builder, ThreadLocal<TraceContext> local) {
        super(builder);
        if (local == null) {
            throw new NullPointerException("local == null");
        }
        this.local = local;
    }

    @Override
    public TraceContext get() {
        return this.local.get();
    }

    @Override
    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        final TraceContext previous = this.local.get();
        this.local.set(currentSpan);
        class ThreadLocalScope
        implements CurrentTraceContext.Scope {
            ThreadLocalScope() {
            }

            @Override
            public void close() {
                ThreadLocalCurrentTraceContext.this.local.set(previous);
            }
        }
        ThreadLocalScope result = new ThreadLocalScope();
        return this.decorateScope(currentSpan, result);
    }

    static final class Builder
    extends CurrentTraceContext.Builder {
        @Override
        public CurrentTraceContext build() {
            return new ThreadLocalCurrentTraceContext(this, DEFAULT);
        }

        Builder() {
        }
    }
}

