/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.netflix.config.DynamicProperty;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PriorityProperty.class);
    private final String[] priorityKeys;
    private final String joinedPriorityKeys;
    private final T invalidValue;
    private final T defaultValue;
    private DynamicProperty[] properties;
    private T finalValue;
    private Function<DynamicProperty, T> internalValueReader;
    private Consumer<T> callback = v -> {};

    PriorityProperty(Type type, T invalidValue, T defaultValue, String ... priorityKeys) {
        this.internalValueReader = this.collectReader(type);
        this.priorityKeys = priorityKeys;
        this.joinedPriorityKeys = Arrays.toString(priorityKeys);
        this.invalidValue = invalidValue;
        this.defaultValue = defaultValue;
        this.properties = new DynamicProperty[priorityKeys.length];
        for (int idx = 0; idx < priorityKeys.length; ++idx) {
            String key = priorityKeys[idx].trim();
            this.properties[idx] = DynamicProperty.getInstance((String)key);
        }
        this.updateFinalValue(true);
    }

    private Function<DynamicProperty, T> collectReader(Type type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return this::readInt;
        }
        if (type == Long.TYPE || type == Long.class) {
            return this::readLong;
        }
        if (type == String.class) {
            return this::readString;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this::readBoolean;
        }
        if (type == Double.TYPE || type == Double.class) {
            return this::readDouble;
        }
        if (type == Float.TYPE || type == Float.class) {
            return this::readFloat;
        }
        throw new IllegalStateException("not support, type=" + type.getTypeName());
    }

    protected T readInt(DynamicProperty property) {
        return (T)property.getInteger();
    }

    protected T readLong(DynamicProperty property) {
        return (T)property.getLong();
    }

    protected T readString(DynamicProperty property) {
        return (T)property.getString();
    }

    protected T readBoolean(DynamicProperty property) {
        return (T)property.getBoolean();
    }

    protected T readDouble(DynamicProperty property) {
        return (T)property.getDouble();
    }

    protected T readFloat(DynamicProperty property) {
        return (T)property.getFloat();
    }

    public String[] getPriorityKeys() {
        return this.priorityKeys;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public DynamicProperty[] getProperties() {
        return this.properties;
    }

    synchronized void updateFinalValue(boolean init) {
        T lastValue = this.finalValue;
        String effectiveKey = "default value";
        T value = this.defaultValue;
        for (DynamicProperty property : this.properties) {
            T propValue = this.internalValueReader.apply(property);
            if (propValue == null || propValue.equals(this.invalidValue)) continue;
            effectiveKey = property.getName();
            value = propValue;
            break;
        }
        if (Objects.equals(lastValue, value)) {
            return;
        }
        if (init) {
            LOGGER.debug("config inited, \"{}\" set to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, value, effectiveKey});
        } else {
            LOGGER.info("config changed, \"{}\" changed from {} to {}, effective key is \"{}\".", new Object[]{this.joinedPriorityKeys, this.finalValue, value, effectiveKey});
        }
        this.finalValue = value;
        this.callback.accept(this.finalValue);
    }

    public T getValue() {
        return this.finalValue;
    }

    public void setCallback(Consumer<T> callback) {
        this.callback = callback;
        callback.accept(this.finalValue);
    }
}

