/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.mqtt.common.facade.MetaPersistManager;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.meta.TopicNotExistException;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FirstTopicManager {
    private static Logger logger = LoggerFactory.getLogger(FirstTopicManager.class);
    private Cache<String, TopicRouteData> topicExistCache;
    private Cache<String, Object> topicNotExistCache;
    private DefaultMQAdminExt defaultMQAdminExt;
    private Map<String, Map<String, String>> brokerAddressMap = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Set<String>> readableBrokers = new ConcurrentHashMap<String, Set<String>>();
    private ScheduledThreadPoolExecutor scheduler;
    @Resource
    private ServiceConf serviceConf;
    @Resource
    private MetaPersistManager metaPersistManager;

    @PostConstruct
    public void init() throws MQClientException {
        this.topicExistCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.topicNotExistCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.initMQAdminExt();
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("refreshStoreBroker"));
        this.scheduler.scheduleWithFixedDelay(() -> {
            HashSet<String> copy = new HashSet<String>();
            copy.add(this.serviceConf.getClientRetryTopic());
            copy.add(this.serviceConf.getClientP2pTopic());
            Set allFirstTopics = this.metaPersistManager.getAllFirstTopics();
            if (allFirstTopics != null) {
                copy.addAll(allFirstTopics);
            }
            for (String firstTopic : copy) {
                this.updateTopicRoute(firstTopic);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public void initMQAdminExt() throws MQClientException {
        this.defaultMQAdminExt = MqFactory.buildDefaultMQAdminExt("TopicCheck", this.serviceConf.getProperties());
        this.defaultMQAdminExt.start();
    }

    public void checkFirstTopicIfCreated(String firstTopic) {
        if (this.topicExistCache.getIfPresent((Object)firstTopic) != null) {
            return;
        }
        if (this.topicNotExistCache.getIfPresent((Object)firstTopic) != null) {
            throw new TopicNotExistException(firstTopic + " NotExist");
        }
        try {
            TopicRouteData topicRouteData = this.defaultMQAdminExt.examineTopicRouteInfo(firstTopic);
            if (topicRouteData == null || topicRouteData.getBrokerDatas() == null || topicRouteData.getBrokerDatas().isEmpty()) {
                this.topicNotExistCache.put((Object)firstTopic, new Object());
                throw new TopicNotExistException(firstTopic + " NotExist");
            }
            this.updateTopicRoute(firstTopic, topicRouteData);
            this.topicExistCache.put((Object)firstTopic, (Object)topicRouteData);
        }
        catch (MQClientException e) {
            if (17 == e.getResponseCode()) {
                this.topicNotExistCache.put((Object)firstTopic, new Object());
                throw new TopicNotExistException(firstTopic + " NotExist");
            }
        }
        catch (Exception e) {
            logger.error("check topic {} exception", (Object)firstTopic, (Object)e);
        }
    }

    private void updateTopicRoute(String firstTopic) {
        if (StringUtils.isBlank((CharSequence)firstTopic)) {
            return;
        }
        try {
            TopicRouteData topicRouteData = this.defaultMQAdminExt.examineTopicRouteInfo(firstTopic);
            this.updateTopicRoute(firstTopic, topicRouteData);
        }
        catch (MQClientException t) {
            if (t.getResponseCode() == 17) {
                this.brokerAddressMap.remove(firstTopic);
                this.readableBrokers.remove(firstTopic);
            }
        }
        catch (Throwable throwable) {
            logger.error("", throwable);
        }
    }

    private void updateTopicRoute(String firstTopic, TopicRouteData topicRouteData) {
        if (topicRouteData == null || firstTopic == null) {
            return;
        }
        ConcurrentHashMap tmp = new ConcurrentHashMap();
        for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
            tmp.put(brokerData.getBrokerName(), brokerData.getBrokerAddrs().get(0L));
        }
        this.brokerAddressMap.put(firstTopic, tmp);
        HashSet<String> tmpBrokers = new HashSet<String>();
        for (QueueData qd : topicRouteData.getQueueDatas()) {
            if (!PermName.isReadable((int)qd.getPerm())) continue;
            tmpBrokers.add(qd.getBrokerName());
        }
        this.readableBrokers.put(firstTopic, tmpBrokers);
    }

    public Map<String, String> getBrokerAddressMap(String firstTopic) {
        ConcurrentHashMap<String, String> copy = new ConcurrentHashMap<String, String>();
        Map<String, String> map = this.brokerAddressMap.get(firstTopic);
        if (map != null) {
            copy.putAll(map);
        }
        return copy;
    }

    public Set<String> getReadableBrokers(String firstTopic) {
        HashSet<String> copy = new HashSet<String>();
        Set<String> set = this.readableBrokers.get(firstTopic);
        if (set != null) {
            copy.addAll(set);
        }
        return copy;
    }
}

