/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter.collector;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.mqtt.exporter.collector.MetricsBuilderFactory;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsInfo;
import org.apache.rocketmq.mqtt.exporter.exception.PrometheusException;
import org.apache.rocketmq.mqtt.exporter.http.MqttHTTPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMetricsCollector {
    public static final CollectorRegistry COLLECTOR_REGISTRY = CollectorRegistry.defaultRegistry;
    private static final Logger LOG = LoggerFactory.getLogger(MqttMetricsCollector.class);
    private static final Map<Collector.Type, Map<MqttMetricsInfo, Collector>> ALL_TYPE_COLLECTORS = new ConcurrentHashMap<Collector.Type, Map<MqttMetricsInfo, Collector>>();
    private static volatile boolean initialized = false;
    private static String namespace;
    private static String hostName;
    private static String hostIp;
    private static MqttHTTPServer httpServer;

    public static synchronized void initialize(String nameSpace, String hostName, String hostIp, int exporterPort) throws IOException {
        if (!initialized) {
            namespace = nameSpace;
            MqttMetricsCollector.hostName = hostName;
            MqttMetricsCollector.hostIp = hostIp;
            MqttMetricsCollector.register(MqttMetricsInfo.values());
            httpServer = new MqttHTTPServer(new InetSocketAddress(exporterPort), COLLECTOR_REGISTRY, false);
            initialized = true;
        }
    }

    private static void register(MqttMetricsInfo[] mqttMetricsInfos) {
        for (MqttMetricsInfo metricsInfo : mqttMetricsInfos) {
            MqttMetricsCollector.register(metricsInfo);
        }
    }

    public static void register(MqttMetricsInfo metricsInfo) {
        Map<MqttMetricsInfo, Collector> mqttMetricsInfoCollectorTypeMap = ALL_TYPE_COLLECTORS.get(metricsInfo.getType());
        if (mqttMetricsInfoCollectorTypeMap == null) {
            mqttMetricsInfoCollectorTypeMap = new ConcurrentHashMap<MqttMetricsInfo, Collector>();
            Map<MqttMetricsInfo, Collector> oldMap = ALL_TYPE_COLLECTORS.putIfAbsent(metricsInfo.getType(), mqttMetricsInfoCollectorTypeMap);
            if (oldMap != null) {
                mqttMetricsInfoCollectorTypeMap = oldMap;
            }
        }
        if (mqttMetricsInfoCollectorTypeMap.get((Object)metricsInfo) == null) {
            SimpleCollector.Builder builder = MetricsBuilderFactory.newCollectorBuilder(metricsInfo);
            if (builder == null) {
                return;
            }
            mqttMetricsInfoCollectorTypeMap.putIfAbsent(metricsInfo, (Collector)MqttMetricsCollector.buildNameSpace(builder, metricsInfo).register(COLLECTOR_REGISTRY));
        }
    }

    public static void unRegister(MqttMetricsInfo metricsInfo) {
        Map<MqttMetricsInfo, Collector> mqttMetricsInfoCollectorTypeMap = ALL_TYPE_COLLECTORS.get(metricsInfo.getType());
        if (mqttMetricsInfoCollectorTypeMap == null) {
            return;
        }
        Collector collector = mqttMetricsInfoCollectorTypeMap.get((Object)metricsInfo);
        if (collector == null) {
            return;
        }
        COLLECTOR_REGISTRY.unregister(collector);
        mqttMetricsInfoCollectorTypeMap.remove((Object)metricsInfo, collector);
    }

    private static SimpleCollector.Builder buildNameSpace(SimpleCollector.Builder builder, MqttMetricsInfo mqttMetricsInfo) {
        return builder.namespace(namespace).subsystem(mqttMetricsInfo.getSubSystem().getValue());
    }

    private static String[] paddingClusterLabelValues(String ... labelValues) {
        String[] newLabelValues = new String[labelValues.length + 2];
        int index = 0;
        newLabelValues[index++] = hostName;
        newLabelValues[index++] = hostIp;
        int i = 0;
        while (i < labelValues.length) {
            newLabelValues[index] = labelValues[i];
            ++i;
            ++index;
        }
        return newLabelValues;
    }

    private static void collect(MqttMetricsInfo mqttMetricsInfo, long val, String ... labels) throws PrometheusException {
        Map<MqttMetricsInfo, Collector> mqttMetricsInfoCollectorTypeMap = ALL_TYPE_COLLECTORS.get(mqttMetricsInfo.getType());
        if (mqttMetricsInfoCollectorTypeMap == null) {
            throw new PrometheusException("mqttMetricsInfo unregistered or collector type not support: " + (Object)((Object)mqttMetricsInfo));
        }
        Collector collector = mqttMetricsInfoCollectorTypeMap.get((Object)mqttMetricsInfo);
        if (collector == null) {
            throw new PrometheusException("mqttMetricsInfo unregistered or collector type not support: " + (Object)((Object)mqttMetricsInfo));
        }
        try {
            if (mqttMetricsInfo.getType() == Collector.Type.COUNTER) {
                Counter counter = (Counter)collector;
                ((Counter.Child)counter.labels(MqttMetricsCollector.paddingClusterLabelValues(labels))).inc((double)val);
            } else if (mqttMetricsInfo.getType() == Collector.Type.GAUGE) {
                Gauge gauge = (Gauge)collector;
                ((Gauge.Child)gauge.labels(MqttMetricsCollector.paddingClusterLabelValues(labels))).set((double)val);
            } else if (mqttMetricsInfo.getType() == Collector.Type.HISTOGRAM) {
                Histogram histogram = (Histogram)collector;
                ((Histogram.Child)histogram.labels(MqttMetricsCollector.paddingClusterLabelValues(labels))).observe((double)val);
            }
        }
        catch (Exception e) {
            LOG.error("collect metrics exception.", new Object[]{MqttMetricsCollector.labels2String(labels), val, e});
            throw new PrometheusException("collect metrics exception", e);
        }
    }

    public static void collectDemoTps(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.DEMO_TPS, val, labels);
    }

    public static void collectDemoGuage(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.DEMO_GAUGE, val, labels);
    }

    public static void collectDemoLatency(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.DEMO_LATENCY, val, labels);
    }

    public static void collectPullStatusTps(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.PULL_STATUS_TPS, val, labels);
    }

    public static void collectPullCacheStatusTps(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.PULL_CACHE_STATUS_TPS, val, labels);
    }

    public static void collectLmqReadWriteMatchActionRt(long val, String ... labels) throws PrometheusException {
        MqttMetricsCollector.collect(MqttMetricsInfo.READ_WRITE_MATCH_ACTION_RT, val, labels);
    }

    private static String labels2String(String ... labels) {
        StringBuilder sb = new StringBuilder(128);
        for (String label : labels) {
            sb.append(label).append(";");
        }
        return sb.toString();
    }

    public static void shutdown() {
        if (httpServer != null) {
            httpServer.close();
        }
    }
}

