/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.util.Constants;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class JvmTools {
    public static List<String> jStack() throws Exception {
        LinkedList<String> stackList = new LinkedList<String>();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stackTraces = entry.getValue();
            stackList.add(String.format("\"%s\" tid=%s isDaemon=%s priority=%s" + Constants.NEWLINE, thread.getName(), thread.getId(), thread.isDaemon(), thread.getPriority()));
            stackList.add("java.lang.Thread.State: " + (Object)((Object)thread.getState()) + Constants.NEWLINE);
            if (stackTraces == null) continue;
            for (StackTraceElement s : stackTraces) {
                stackList.add("    " + s.toString() + Constants.NEWLINE);
            }
        }
        return stackList;
    }

    public static List<String> memoryUsage() throws Exception {
        MemoryUsage heapMemoryUsage = MXBeanHolder.memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = MXBeanHolder.memoryMxBean.getNonHeapMemoryUsage();
        LinkedList<String> memoryUsageList = new LinkedList<String>();
        memoryUsageList.add("********************************** Memory Usage **********************************" + Constants.NEWLINE);
        memoryUsageList.add("Heap Memory Usage: " + heapMemoryUsage.toString() + Constants.NEWLINE);
        memoryUsageList.add("NonHeap Memory Usage: " + nonHeapMemoryUsage.toString() + Constants.NEWLINE);
        return memoryUsageList;
    }

    public static double memoryUsed() throws Exception {
        MemoryUsage heapMemoryUsage = MXBeanHolder.memoryMxBean.getHeapMemoryUsage();
        return (double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax();
    }

    public static void jMap(String outputFile, boolean live) throws Exception {
        File file = new File(outputFile);
        if (file.exists()) {
            file.delete();
        }
        MXBeanHolder.hotSpotDiagnosticMxBean.dumpHeap(outputFile, live);
    }

    private JvmTools() {
    }

    private static class MXBeanHolder {
        static final MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        static final HotSpotDiagnosticMXBean hotSpotDiagnosticMxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);

        private MXBeanHolder() {
        }
    }
}

