/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ThreadUtils;

public class TieredStoreExecutor {
    public static final int QUEUE_CAPACITY = 10000;
    public static BlockingQueue<Runnable> dispatchThreadPoolQueue;
    public static BlockingQueue<Runnable> fetchDataThreadPoolQueue;
    public static BlockingQueue<Runnable> compactIndexFileThreadPoolQueue;
    public static ScheduledExecutorService commonScheduledExecutor;
    public static ScheduledExecutorService commitExecutor;
    public static ScheduledExecutorService cleanExpiredFileExecutor;
    public static ExecutorService dispatchExecutor;
    public static ExecutorService fetchDataExecutor;
    public static ExecutorService compactIndexFileExecutor;

    public static void init() {
        commonScheduledExecutor = ThreadUtils.newScheduledThreadPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCommonExecutor_"));
        commitExecutor = ThreadUtils.newScheduledThreadPool((int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (ThreadFactory)new ThreadFactoryImpl("TieredCommitExecutor_"));
        cleanExpiredFileExecutor = ThreadUtils.newScheduledThreadPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCleanFileExecutor_"));
        dispatchThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        dispatchExecutor = ThreadUtils.newThreadPoolExecutor((int)Math.max(2, Runtime.getRuntime().availableProcessors()), (int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, dispatchThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredDispatchExecutor_"), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        fetchDataThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        fetchDataExecutor = ThreadUtils.newThreadPoolExecutor((int)Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (int)Math.max(64, Runtime.getRuntime().availableProcessors() * 8), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, fetchDataThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredFetchExecutor_"));
        compactIndexFileThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        compactIndexFileExecutor = ThreadUtils.newThreadPoolExecutor((int)1, (int)1, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, compactIndexFileThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredCompactIndexFileExecutor_"));
    }

    public static void shutdown() {
        TieredStoreExecutor.shutdownExecutor(dispatchExecutor);
        TieredStoreExecutor.shutdownExecutor(commonScheduledExecutor);
        TieredStoreExecutor.shutdownExecutor(commitExecutor);
        TieredStoreExecutor.shutdownExecutor(cleanExpiredFileExecutor);
        TieredStoreExecutor.shutdownExecutor(fetchDataExecutor);
        TieredStoreExecutor.shutdownExecutor(compactIndexFileExecutor);
    }

    private static void shutdownExecutor(ExecutorService executor) {
        if (executor != null) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
            }
        }
    }
}

