/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.MacRomanEncoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.TrueTypeContainer;
import org.apache.pdfbox.preflight.font.descriptor.TrueTypeDescriptorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeFontValidator
extends SimpleFontValidator<TrueTypeContainer> {
    public TrueTypeFontValidator(PreflightContext context, PDFont font) {
        super(context, font, new TrueTypeContainer(font));
    }

    @Override
    protected void createFontDescriptorHelper() {
        this.descriptorHelper = new TrueTypeDescriptorHelper(this.context, this.font, (TrueTypeContainer)this.fontContainer);
    }

    @Override
    protected void checkEncoding() {
        PDFontDescriptor fd = this.font.getFontDescriptor();
        if (fd != null) {
            Encoding encodingValue;
            if (fd.isNonSymbolic() && ((encodingValue = this.font.getFontEncoding()) == null || !(encodingValue instanceof MacRomanEncoding) && !(encodingValue instanceof WinAnsiEncoding))) {
                ((TrueTypeContainer)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5", "The Encoding is invalid for the NonSymbolic TTF"));
            }
            if (fd.isSymbolic() && ((COSDictionary)this.font.getCOSObject()).getItem(COSName.ENCODING) != null) {
                ((TrueTypeContainer)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5", "The Encoding should be missing for the Symbolic TTF"));
            }
        }
    }
}

