/*
 * Decompiled with CFR 0.152.
 */
package com.drew.tools;

import com.drew.lang.annotations.NotNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtil {
    public static void saveBytes(@NotNull File file, @NotNull byte[] bytes) throws IOException {
        try (FileOutputStream stream = null;){
            stream = new FileOutputStream(file);
            stream.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] readBytes(@NotNull File file) throws IOException {
        int length = (int)file.length();
        assert (length != 0);
        byte[] bytes = new byte[length];
        try (FileInputStream inputStream = null;){
            int bytesRead;
            inputStream = new FileInputStream(file);
            for (int totalBytesRead = 0; totalBytesRead != length; totalBytesRead += bytesRead) {
                bytesRead = inputStream.read(bytes, totalBytesRead, length - totalBytesRead);
                if (bytesRead != -1) continue;
                break;
            }
        }
        return bytes;
    }

    @NotNull
    public static byte[] readBytes(@NotNull String filePath) throws IOException {
        return FileUtil.readBytes(new File(filePath));
    }
}

