/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.process;

public class ProcessResult {
    public static final Integer ZERO = 0;
    private String process;
    private String command;
    private String exception;
    private String error;
    private Integer exitCode;
    private String out;
    private boolean optional = false;

    public ProcessResult() {
        this(null, null, null);
    }

    public ProcessResult(String error) {
        this(null, error, null);
    }

    public ProcessResult(String process, String error, Exception ex) {
        this.setProcess(process);
        this.setException(ex == null ? null : ex.toString());
        this.setError(error);
        this.setExitCode(-1);
    }

    public String getOut() {
        return this.out;
    }

    public ProcessResult setOut(String out) {
        this.out = out;
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public ProcessResult setCommand(String command) {
        this.command = command;
        return this;
    }

    public String getProcess() {
        return this.process;
    }

    public ProcessResult setProcess(String process) {
        this.process = process;
        return this;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getError() {
        return this.error;
    }

    public ProcessResult setError(String error) {
        this.error = error;
        return this;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public ProcessResult setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public ProcessResult setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public boolean isOk() {
        return this.optional || !this.isWarn();
    }

    public boolean isWarn() {
        return !ZERO.equals(this.exitCode);
    }

    public String buildLogMessage() {
        return "process: " + this.process + "\r\n" + "command: " + this.command + "\r\n" + "exception: " + this.exception + "\r\n" + "error: " + this.error + "\r\n" + "exitValue: " + this.exitCode + "\r\n" + "optional: " + this.optional + "\r\n" + "out: " + this.out + "\r\n";
    }
}

