/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.Trunk;

public class EndPointImpl
implements EndPoint {
    private static final String DELIMITER = "/";
    private final TechType _tech;
    private final String _endPointName;
    private final String _fullyQualifiedName;
    private final boolean _empty;
    private Trunk _trunk;

    public EndPointImpl(String fullyQualifiedEndPoint) {
        if (fullyQualifiedEndPoint == null) {
            throw new IllegalArgumentException("The fullyQualifiedEndPoint may not be null");
        }
        String cleaned = this.clean(fullyQualifiedEndPoint);
        this._tech = TechType.getTech(cleaned);
        this._endPointName = cleaned.substring(this._tech.name().length() + 1);
        this._fullyQualifiedName = this._tech == TechType.DIALPLAN ? this._endPointName : this._tech.name() + DELIMITER + this._endPointName;
        this._empty = false;
    }

    public EndPointImpl() {
        this._empty = true;
        this._tech = TechType.UNKNOWN;
        this._endPointName = "";
        this._fullyQualifiedName = "";
    }

    public EndPointImpl(TechType defaultTech, String endPointName) {
        if (endPointName == null) {
            throw new IllegalArgumentException("The endPointName may not be null");
        }
        String cleaned = this.clean(endPointName);
        if (cleaned.length() == 0) {
            throw new IllegalArgumentException("The endPointName may not be empty");
        }
        if (TechType.hasTech(cleaned)) {
            this._tech = TechType.getTech(cleaned);
            this._endPointName = cleaned.substring(this._tech.name().length() + 1);
        } else {
            this._tech = defaultTech;
            this._endPointName = cleaned;
        }
        this._fullyQualifiedName = this._tech == TechType.DIALPLAN ? this._endPointName : this._tech.name() + DELIMITER + this._endPointName;
        this._empty = false;
    }

    public EndPointImpl(TechType defaultTech, Trunk trunk, String endPointName) {
        if (endPointName == null) {
            throw new IllegalArgumentException("The endPointName may not be null");
        }
        String cleaned = this.clean(endPointName);
        if (cleaned.length() == 0) {
            throw new IllegalArgumentException("The endPointName may not be empty");
        }
        if (TechType.hasTech(cleaned)) {
            throw new IllegalArgumentException("endPointName may not contain a Tech");
        }
        this._tech = defaultTech;
        this._endPointName = cleaned;
        this._trunk = trunk;
        if (this._tech == TechType.DIALPLAN || this._tech == TechType.CONSOLE || this._tech == TechType.LOCAL) {
            throw new IllegalArgumentException("defaultTech may not be DIALPLAN, LOCAL or CONSOLE");
        }
        this._fullyQualifiedName = this._tech.name() + DELIMITER + trunk.getTrunkAsString() + DELIMITER + this._endPointName;
        this._empty = false;
    }

    @Override
    public String getFullyQualifiedName() {
        return this._fullyQualifiedName;
    }

    public Trunk getTrunk() {
        return this._trunk;
    }

    @Override
    public boolean isSame(EndPoint rhs) {
        return this.compareTo(rhs) == 0;
    }

    @Override
    public int compareTo(EndPoint rhs) {
        return this.getFullyQualifiedName().compareTo(rhs.getFullyQualifiedName());
    }

    @Override
    public boolean isLocal() {
        return this._tech == TechType.LOCAL;
    }

    @Override
    public boolean isSIP() {
        return this._tech == TechType.SIP || this._tech == TechType.IAX || this._tech == TechType.IAX2;
    }

    public boolean isDAHDI() {
        return this._tech == TechType.DAHDI;
    }

    @Override
    public String getSimpleName() {
        return this._endPointName;
    }

    @Override
    public boolean isUnknown() {
        return this._tech == TechType.UNKNOWN;
    }

    private String clean(String _endPointName) {
        String localTo = _endPointName.trim();
        int tmp = localTo.indexOf(" ");
        while (tmp != -1) {
            localTo = localTo.substring(0, tmp) + localTo.substring(tmp + 1, localTo.length());
            tmp = localTo.indexOf(" ");
        }
        return localTo.toLowerCase();
    }

    @Override
    public TechType getTech() {
        return this._tech;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    @Override
    public String getSIPSimpleName() {
        String name = this.isSIP() ? this.getSimpleName() : this.getFullyQualifiedName();
        return name;
    }

    @Override
    public boolean isEmpty() {
        return this._empty;
    }
}

