/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiChannelFactory;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.AsyncAgiConnectionHandler;
import org.asteriskjava.fastagi.internal.DefaultAgiChannelFactory;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.AsyncAgiEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsyncAgiServer
extends AbstractAgiServer
implements ManagerEventListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LockableMap<Integer, AsyncAgiConnectionHandler> connectionHandlers = new LockableMap(new HashMap());

    public AsyncAgiServer() {
        this(new DefaultAgiChannelFactory());
    }

    public AsyncAgiServer(AgiChannelFactory agiChannelFactory) {
        super(agiChannelFactory);
    }

    public AsyncAgiServer(MappingStrategy mappingStrategy) {
        this(mappingStrategy, (AgiChannelFactory)new DefaultAgiChannelFactory());
        this.logger.debug("use default AgiChannelFactory");
    }

    public AsyncAgiServer(MappingStrategy mappingStrategy, AgiChannelFactory agiChannelFactory) {
        this(agiChannelFactory);
        this.setMappingStrategy(mappingStrategy);
    }

    public AsyncAgiServer(AgiScript agiScript, AgiChannelFactory agiChannelFactory) {
        this(agiChannelFactory);
        this.setMappingStrategy(new StaticMappingStrategy(agiScript));
    }

    public AsyncAgiServer(AgiScript agiScript) {
        this(agiScript, (AgiChannelFactory)new DefaultAgiChannelFactory());
        this.logger.debug("use default AgiChannelFactory");
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof AsyncAgiEvent) {
            this.handleAsyncAgiEvent((AsyncAgiEvent)event);
        } else if (event instanceof RenameEvent) {
            this.handleRenameEvent((RenameEvent)event);
        }
    }

    private void handleAsyncAgiEvent(AsyncAgiEvent asyncAgiEvent) {
        ManagerConnection connection = (ManagerConnection)asyncAgiEvent.getSource();
        String channelName = asyncAgiEvent.getChannel();
        if (asyncAgiEvent.isStart()) {
            AsyncAgiConnectionHandler connectionHandler = new AsyncAgiConnectionHandler(this.getMappingStrategy(), asyncAgiEvent, this.getAgiChannelFactory());
            this.setConnectionHandler(connection, channelName, connectionHandler);
            try {
                this.execute(connectionHandler);
            }
            catch (RejectedExecutionException e) {
                this.logger.warn("Execution was rejected by pool. Try to increase the pool size.");
                connectionHandler.release();
            }
        } else {
            AsyncAgiConnectionHandler connectionHandler = this.getConnectionHandler(connection, channelName);
            if (connectionHandler == null) {
                this.logger.info("No AsyncAgiConnectionHandler registered for channel " + channelName + ": Ignoring AsyncAgiEvent");
                return;
            }
            if (asyncAgiEvent.isExec()) {
                connectionHandler.onAsyncAgiExecEvent(asyncAgiEvent);
            } else if (asyncAgiEvent.isEnd()) {
                connectionHandler.onAsyncAgiEndEvent(asyncAgiEvent);
                this.removeConnectionHandler(connection, channelName);
            } else {
                this.logger.warn("Ignored unknown AsyncAgiEvent of sub type '" + asyncAgiEvent.getSubEvent() + "'");
            }
        }
    }

    private void handleRenameEvent(RenameEvent renameEvent) {
        ManagerConnection connection = (ManagerConnection)renameEvent.getSource();
        AsyncAgiConnectionHandler connectionHandler = this.getConnectionHandler(connection, renameEvent.getChannel());
        if (connectionHandler == null) {
            return;
        }
        this.removeConnectionHandler(connection, renameEvent.getChannel());
        this.setConnectionHandler(connection, renameEvent.getNewname(), connectionHandler);
        connectionHandler.updateChannelName(renameEvent.getNewname());
    }

    private AsyncAgiConnectionHandler getConnectionHandler(ManagerConnection connection, String channelName) {
        try (Locker.LockCloser closer = this.connectionHandlers.withLock();){
            AsyncAgiConnectionHandler asyncAgiConnectionHandler = this.connectionHandlers.get(this.calculateHashKey(connection, channelName));
            return asyncAgiConnectionHandler;
        }
    }

    private void setConnectionHandler(ManagerConnection connection, String channelName, AsyncAgiConnectionHandler connectionHandler) {
        try (Locker.LockCloser closer = this.connectionHandlers.withLock();){
            this.connectionHandlers.put(this.calculateHashKey(connection, channelName), connectionHandler);
        }
    }

    private void removeConnectionHandler(ManagerConnection connection, String channelName) {
        try (Locker.LockCloser closer = this.connectionHandlers.withLock();){
            this.connectionHandlers.remove(this.calculateHashKey(connection, channelName));
        }
    }

    private Integer calculateHashKey(ManagerConnection connection, String channelName) {
        return connection.hashCode() * 31 + channelName.hashCode();
    }
}

