/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.room;

import jakarta.inject.Inject;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IInvitationManager;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.service.mail.template.InvitationTemplate;
import org.apache.openmeetings.service.mail.template.subject.CanceledAppointmentTemplate;
import org.apache.openmeetings.service.mail.template.subject.CreatedAppointmentTemplate;
import org.apache.openmeetings.service.mail.template.subject.SubjectEmailTemplate;
import org.apache.openmeetings.service.mail.template.subject.UpdatedAppointmentTemplate;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.mail.IcalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvitationManager
implements IInvitationManager {
    private static final Logger log = LoggerFactory.getLogger(InvitationManager.class);
    @Inject
    private InvitationDao invitationDao;
    @Inject
    private MailHandler mailHandler;

    private void sendInvitionLink(Appointment a, MeetingMember mm, Invitation.MessageType type, boolean ical) {
        User owner = a.getOwner();
        String invitorName = owner.getDisplayName();
        TimeZone tz = TimezoneUtil.getTimeZone((User)mm.getUser());
        SubjectEmailTemplate t = switch (type) {
            case Invitation.MessageType.CANCEL -> CanceledAppointmentTemplate.get(mm.getUser(), a, tz, invitorName);
            case Invitation.MessageType.CREATE -> CreatedAppointmentTemplate.get(mm.getUser(), a, tz, invitorName);
            default -> UpdatedAppointmentTemplate.get(mm.getUser(), a, tz, invitorName);
        };
        this.sendInvitationLink(mm.getInvitation(), type, t.getSubject(), t.getEmail(), ical, null);
    }

    public void sendInvitationLink(Invitation i, Invitation.MessageType type, String subject, String message, boolean ical, String baseUrl) {
        String invitationLink;
        if (type != Invitation.MessageType.CANCEL) {
            IApplication app = ApplicationHelper.ensureApplication((Long)1L);
            invitationLink = app.getOmInvitationLink(i, baseUrl);
        } else {
            invitationLink = null;
        }
        User owner = i.getInvitedBy();
        String invitorName = owner.getDisplayName();
        String template = InvitationTemplate.getEmail(i.getInvitee(), invitorName, message, invitationLink, i.getRoom() != null);
        String email = i.getInvitee().getAddress().getEmail();
        String replyToEmail = owner.getAddress().getEmail();
        if (ical) {
            Object desc;
            boolean isOwner = owner.getId().equals(i.getInvitee().getId());
            Appointment a = i.getAppointment();
            Object object = desc = a.getDescription() == null ? "" : a.getDescription();
            if (invitationLink != null) {
                desc = (String)desc + (((String)desc).isEmpty() ? "" : "\n\n\n") + invitationLink;
            }
            String tzid = TimezoneUtil.getTimeZone((User)owner).getID();
            IcalHandler handler = new IcalHandler(Invitation.MessageType.CANCEL == type ? IcalHandler.ICAL_METHOD_CANCEL : IcalHandler.ICAL_METHOD_REQUEST).createVEvent(CalendarHelper.getZoneDateTime((Date)a.getStart(), (String)tzid), CalendarHelper.getZoneDateTime((Date)a.getEnd(), (String)tzid), a.getTitle()).addOrganizer(replyToEmail, owner.getDisplayName()).setUid(a.getIcalId()).addAttendee(email, i.getInvitee().getDisplayName(), isOwner).setCreated(CalendarHelper.getZoneDateTime((Date)a.getInserted(), (String)tzid)).setDescription((String)desc).setModified(CalendarHelper.getZoneDateTime((Date)a.getUpdated(), (String)tzid)).setLocation(a.getLocation()).setSequence(0).build();
            log.debug("IcalHandler {}", (Object)handler);
            this.mailHandler.send(new MailMessage(email, replyToEmail, subject, template, handler));
        } else {
            this.mailHandler.send(email, replyToEmail, subject, template);
        }
    }

    public void processInvitation(Appointment a, MeetingMember member, Invitation.MessageType type) {
        this.processInvitation(a, member, type, true);
    }

    public void processInvitation(Appointment a, MeetingMember mm, Invitation.MessageType type, boolean sendMail) {
        Appointment.Reminder reminder = a.getReminder();
        if (reminder == null) {
            log.error("Appointment doesn't have reminder set!");
            return;
        }
        if (Appointment.Reminder.NONE == reminder) {
            log.error("MeetingMember should not have invitation!");
            return;
        }
        log.debug(":::: processInvitation ..... {}", (Object)reminder);
        log.debug("Invitation for Appointment : simple email");
        try {
            mm.setInvitation(this.getInvitation(mm.getInvitation(), mm.getUser(), a.getRoom(), a.isPasswordProtected(), a.getPassword(), Invitation.Valid.PERIOD, a.getOwner(), null, a.getStart(), a.getEnd(), a));
            if (sendMail) {
                this.sendInvitionLink(a, mm, type, Appointment.Reminder.ICAL == reminder);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error while setting invitation", (Throwable)e);
        }
    }

    public Invitation getInvitation(Invitation inInvitation, User inveetee, Room room, boolean isPasswordProtected, String invitationpass, Invitation.Valid valid, User createdBy, Long languageId, Date mmStart, Date mmEnd, Appointment appointment) {
        Invitation invitation = inInvitation;
        if (null == inInvitation) {
            invitation = new Invitation();
            invitation.setHash(UUID.randomUUID().toString());
        }
        invitation.setPasswordProtected(isPasswordProtected);
        if (isPasswordProtected) {
            invitation.setPassword(CryptProvider.get().hash(invitationpass));
        }
        invitation.setUsed(false);
        invitation.setValid(valid);
        switch (valid) {
            case PERIOD: {
                invitation.setValidFrom(Appointment.allowedStart((Date)mmStart));
                invitation.setValidTo(mmEnd);
                break;
            }
        }
        invitation.setDeleted(false);
        invitation.setInvitedBy(createdBy);
        invitation.setInvitee(inveetee);
        if (languageId != null && User.Type.CONTACT == invitation.getInvitee().getType()) {
            invitation.getInvitee().setLanguageId(languageId.longValue());
        }
        invitation.setRoom(room);
        invitation.setAppointment(appointment);
        return invitation;
    }

    public Invitation getInvitation(User inveetee, Room room, boolean isPasswordProtected, String invitationpass, Invitation.Valid valid, User createdBy, Long languageId, Date mmStart, Date mmEnd, Appointment appointment) {
        Invitation i = this.getInvitation(null, inveetee, room, isPasswordProtected, invitationpass, valid, createdBy, languageId, mmStart, mmEnd, appointment);
        i = this.invitationDao.update(i);
        return i;
    }
}

