/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.wicket.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimerService {
    private static final Logger log = LoggerFactory.getLogger(TimerService.class);
    private int modCheckInterval = 5;
    private int sipCheckInterval = 2;
    private final User sysUser = new User();
    private final Map<Long, CompletableFuture<Object>> modCheckMap = new ConcurrentHashMap<Long, CompletableFuture<Object>>();
    private final Map<Long, CompletableFuture<Object>> sipCheckMap = new ConcurrentHashMap<Long, CompletableFuture<Object>>();
    @Inject
    private ClientManager cm;
    @Inject
    private SipManager sipManager;
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private Application app;

    @PostConstruct
    private void init() {
        this.sysUser.setId(Long.valueOf(-5L));
        this.sysUser.setDisplayName("System");
    }

    private void doModCheck(Long roomId) {
        this.modCheckMap.put(roomId, new CompletableFuture<Object>().completeAsync(() -> {
            ThreadContext.setApplication((org.apache.wicket.Application)this.app);
            log.warn("Moderator room check {}", (Object)roomId);
            if (this.cm.streamByRoom(roomId).findAny().isEmpty()) {
                this.modCheckMap.remove(roomId);
            } else {
                WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(roomId, this.sysUser, RoomMessage.Type.MODERATOR_IN_ROOM, "" + !this.cm.streamByRoom(roomId).filter(c -> c.hasRight(Room.Right.MODERATOR)).findAny().isEmpty()));
                this.doModCheck(roomId);
            }
            return null;
        }, CompletableFuture.delayedExecutor(this.modCheckInterval, TimeUnit.SECONDS)));
    }

    private void doSipCheck(Long roomId) {
        this.sipCheckMap.put(roomId, new CompletableFuture<Object>().completeAsync(() -> {
            ThreadContext.setApplication((org.apache.wicket.Application)this.app);
            log.trace("Sip room check {}", (Object)roomId);
            Optional<Client> sipClient = this.cm.streamByRoom(roomId).filter(Client::isSip).findAny();
            this.cm.streamByRoom(roomId).filter(Predicate.not(Client::isSip)).findAny().ifPresentOrElse(c -> {
                this.updateSipLastName(sipClient, c.getRoom());
                this.doSipCheck(roomId);
            }, () -> {
                log.warn("No more clients in the room {}", (Object)roomId);
                this.sipCheckMap.remove(roomId);
                sipClient.ifPresent(this.cm::exit);
            });
            return null;
        }, CompletableFuture.delayedExecutor(this.sipCheckInterval, TimeUnit.SECONDS)));
    }

    private void updateSipLastName(Optional<Client> sipClient, Room r) {
        long count = this.sipManager.countUsers(r.getConfno());
        String newLastName = "(" + count + ")";
        sipClient.ifPresentOrElse(c -> {
            if (!newLastName.equals(c.getUser().getLastname())) {
                c.getUser().setLastname(newLastName).resetDisplayName();
                this.cm.update((Client)c);
                WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(r.getId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
            }
        }, () -> {
            User sipUser = this.sipManager.getSipUser(r);
            sipUser.setLastname(newLastName).resetDisplayName();
            Client c = new Client("-- unique - sip - session --", 1, sipUser, sipUser.getPictureUri());
            c.allow(new Room.Right[]{Room.Right.VIDEO, Room.Right.AUDIO});
            this.cm.add(c);
            c.setRoom(r);
            this.cm.addToRoom(c);
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(r.getId(), c, RoomMessage.Type.ROOM_ENTER, c.getUid()));
        });
        this.kHandler.updateSipCount(r, count);
    }

    public void scheduleModCheck(Room r) {
        if (r.isModerated() && r.isWaitModerator() && !this.modCheckMap.containsKey(r.getId())) {
            this.doModCheck(r.getId());
        }
    }

    public void scheduleSipCheck(Room r) {
        if (this.sipManager.getSipUser(r) != null && r.isSipEnabled() && !this.sipCheckMap.containsKey(r.getId())) {
            this.doSipCheck(r.getId());
        }
    }
}

