/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import java.io.IOException;

public class CachedQueryEntry<K, V>
extends QueryableEntry<K, V>
implements IdentifiedDataSerializable {
    protected Data keyData;
    protected Data valueData;
    protected K keyObject;
    protected V valueObject;

    public CachedQueryEntry() {
    }

    public CachedQueryEntry(SerializationService ss, Object key, Object value, Extractors extractors) {
        this.init(ss, key, value, extractors);
    }

    public CachedQueryEntry(SerializationService ss, Extractors extractors) {
        this.serializationService = (InternalSerializationService)ss;
        this.extractors = extractors;
    }

    public CachedQueryEntry<K, V> init(SerializationService ss, Object key, Object value, Extractors extractors) {
        this.serializationService = (InternalSerializationService)ss;
        this.extractors = extractors;
        return this.init(key, value);
    }

    public CachedQueryEntry<K, V> init(Object key, Object value) {
        Data data;
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        if (key instanceof Data) {
            this.keyData = data = (Data)key;
            this.keyObject = null;
        } else {
            this.keyObject = key;
            this.keyData = null;
        }
        if (value instanceof Data) {
            this.valueData = data = (Data)value;
            this.valueObject = null;
        } else {
            this.valueObject = value;
            this.valueData = null;
        }
        return this;
    }

    public CachedQueryEntry<K, V> initWithObjectKeyValue(Object key, Object value) {
        this.keyObject = key;
        this.keyData = null;
        this.valueObject = value;
        this.valueData = null;
        return this;
    }

    @Override
    public K getKey() {
        if (this.keyObject == null) {
            this.keyObject = this.serializationService.toObject(this.keyData);
        }
        return this.keyObject;
    }

    @Override
    public Data getKeyData() {
        return this.keyData;
    }

    @Override
    public V getValue() {
        if (this.valueObject == null) {
            this.valueObject = this.serializationService.toObject(this.valueData);
        }
        return this.valueObject;
    }

    @Override
    public Data getValueData() {
        if (this.valueData == null) {
            this.valueData = this.serializationService.toData(this.valueObject);
        }
        return this.valueData;
    }

    @Override
    public K getKeyIfPresent() {
        return this.keyObject != null ? (K)this.keyObject : null;
    }

    @Override
    public Data getKeyDataIfPresent() {
        return this.keyData;
    }

    @Override
    public V getValueIfPresent() {
        if (this.valueObject != null) {
            return this.valueObject;
        }
        if (this.record == null) {
            return null;
        }
        Object possiblyNotData = this.record.getValue();
        return possiblyNotData instanceof Data ? null : (V)possiblyNotData;
    }

    @Override
    public Data getValueDataIfPresent() {
        Data data;
        if (this.valueData != null) {
            return this.valueData;
        }
        if (this.record == null) {
            return null;
        }
        Object possiblyData = this.record.getValue();
        return possiblyData instanceof Data ? (data = (Data)possiblyData) : null;
    }

    public Object getByPrioritizingDataValue() {
        if (this.valueData != null) {
            return this.valueData;
        }
        if (this.valueObject != null) {
            return this.valueObject;
        }
        return null;
    }

    public Object getByPrioritizingObjectValue() {
        if (this.valueObject != null) {
            return this.valueObject;
        }
        if (this.valueData != null) {
            return this.valueData;
        }
        return null;
    }

    @Override
    protected Object getTargetObject(boolean key) {
        Object targetObject = key ? (this.keyData.isPortable() || this.keyData.isJson() || this.keyData.isCompact() ? this.keyData : this.getKey()) : (this.valueObject == null ? this.getTargetObjectFromData() : (this.valueObject instanceof PortableGenericRecord || this.valueObject instanceof CompactGenericRecord ? this.getValue() : (this.valueObject instanceof Portable || this.serializationService.isCompactSerializable(this.valueObject) ? this.getValueData() : this.getValue())));
        return targetObject;
    }

    private Object getTargetObjectFromData() {
        if (this.valueData == null) {
            return null;
        }
        if (this.valueData.isPortable() || this.valueData.isJson() || this.valueData.isCompact()) {
            return this.valueData;
        }
        return this.getValue();
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedQueryEntry that = (CachedQueryEntry)o;
        return this.keyData.equals(that.keyData);
    }

    @Override
    public int hashCode() {
        return this.keyData.hashCode();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.getKey());
        out.writeObject(this.getValue());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.keyObject = in.readObject();
        this.valueObject = in.readObject();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 120;
    }
}

