/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import java.util.Objects;
import javax.annotation.Nullable;

public final class JetAssert {
    private JetAssert() {
    }

    public static void assertTrue(@Nullable String message, boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertFalse(@Nullable String message, boolean condition) {
        JetAssert.assertTrue(message, !condition);
    }

    public static void assertSame(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        if (expected == actual) {
            return;
        }
        JetAssert.throwNotEqual(message, expected, actual);
    }

    public static void assertEquals(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        if (Objects.equals(expected, actual)) {
            return;
        }
        JetAssert.throwNotEqual(message, expected, actual);
    }

    public static void fail(@Nullable String message) {
        throw new AssertionError((Object)message);
    }

    private static void throwNotEqual(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        if (message != null && !((String)message).isEmpty()) {
            message = (String)message + " ";
        }
        message = (expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual)) ? (String)message + ", expected: " + JetAssert.formatClassAndValue(expected, expectedString) + " but was: " + JetAssert.formatClassAndValue(actual, actualString) : (String)message + ", expected:<" + expectedString + "> but was:<" + actualString + ">";
        throw new AssertionError(message);
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }
}

