/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterTopologyChangedException;
import com.hazelcast.internal.dynamicconfig.AbstractDynamicConfigOperation;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class UpdateDynamicConfigOperation
extends AbstractDynamicConfigOperation {
    protected IdentifiedDataSerializable config;
    protected int memberListVersion;
    @Nullable
    protected String userCodeNamespace;

    protected UpdateDynamicConfigOperation() {
    }

    protected UpdateDynamicConfigOperation(IdentifiedDataSerializable config, int memberListVersion, @Nullable String userCodeNamespace) {
        this.config = config;
        this.userCodeNamespace = userCodeNamespace;
        this.memberListVersion = memberListVersion;
    }

    @Override
    public void run() throws Exception {
        int currentMemberListVersion;
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        if (clusterService.isMaster() && (currentMemberListVersion = clusterService.getMemberListVersion()) != this.memberListVersion) {
            throw new ClusterTopologyChangedException(String.format("Current member list version %d does not match expected %d", currentMemberListVersion, this.memberListVersion));
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.userCodeNamespace);
        out.writeObject(this.config);
        out.writeInt(this.memberListVersion);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.userCodeNamespace = in.readString();
        this.config = NamespaceUtil.callWithNamespace(this.userCodeNamespace, in::readObject);
        this.memberListVersion = in.readInt();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return throwable instanceof ClusterTopologyChangedException ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }
}

