/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.UUID;

public class MembersViewResponse
implements IdentifiedDataSerializable {
    private Address memberAddress;
    private UUID memberUuid;
    private MembersView membersView;

    public MembersViewResponse() {
    }

    public MembersViewResponse(Address memberAddress, UUID memberUuid, MembersView membersView) {
        this.memberAddress = memberAddress;
        this.memberUuid = memberUuid;
        this.membersView = membersView;
    }

    public Address getMemberAddress() {
        return this.memberAddress;
    }

    public UUID getMemberUuid() {
        return this.memberUuid;
    }

    public MembersView getMembersView() {
        return this.membersView;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.memberAddress);
        UUIDSerializationUtil.writeUUID(out, this.memberUuid);
        out.writeObject(this.membersView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.memberAddress = (Address)in.readObject();
        this.memberUuid = UUIDSerializationUtil.readUUID(in);
        this.membersView = (MembersView)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 42;
    }
}

