/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.ascii.TextProtocolsDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class RestValue
implements IdentifiedDataSerializable {
    private byte[] value;
    private byte[] contentType;

    public RestValue() {
    }

    public RestValue(byte[] value, byte[] contentType) {
        this.value = value;
        this.contentType = contentType;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.value = in.readByteArray();
        this.contentType = in.readByteArray();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByteArray(this.value);
        out.writeByteArray(this.contentType);
    }

    public byte[] getContentType() {
        return this.contentType;
    }

    public void setContentType(byte[] contentType) {
        this.contentType = contentType;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String toString() {
        String contentTypeStr = this.contentType == null ? "unknown-content-type" : new String(this.contentType, StandardCharsets.UTF_8);
        Object valueStr = this.value == null ? "value.length=0" : (contentTypeStr.contains("text") ? "value=\"" + new String(this.value, StandardCharsets.UTF_8) + "\"" : "value.length=" + this.value.length);
        return "RestValue{contentType='" + contentTypeStr + "', " + (String)valueStr + "}";
    }

    @Override
    public int getFactoryId() {
        return TextProtocolsDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

