/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;

public class VaultSecureStoreConfig
extends SecureStoreConfig {
    public static final int DEFAULT_POLLING_INTERVAL = 0;
    private String address;
    private String secretPath;
    private String token;
    private SSLConfig sslConfig;
    private int pollingInterval = 0;

    public VaultSecureStoreConfig(String address, String secretPath, String token) {
        Preconditions.checkNotNull(address, "Vault server address cannot be null!");
        Preconditions.checkNotNull(secretPath, "Vault secret path cannot be null!");
        Preconditions.checkNotNull(token, "Vault token cannot be null!");
        this.address = address;
        this.secretPath = secretPath;
        this.token = token;
    }

    public String getAddress() {
        return this.address;
    }

    public VaultSecureStoreConfig setAddress(String address) {
        Preconditions.checkNotNull(address, "Vault server address cannot be null!");
        this.address = address;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public VaultSecureStoreConfig setToken(String token) {
        Preconditions.checkNotNull(token, "Vault token cannot be null!");
        this.token = token;
        return this;
    }

    public String getSecretPath() {
        return this.secretPath;
    }

    public VaultSecureStoreConfig setSecretPath(String secretPath) {
        Preconditions.checkNotNull(secretPath, "Vault secret path cannot be null!");
        this.secretPath = secretPath;
        return this;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public VaultSecureStoreConfig setPollingInterval(int pollingInterval) {
        Preconditions.checkNotNegative(pollingInterval, "Polling interval cannot be negative!");
        this.pollingInterval = pollingInterval;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public VaultSecureStoreConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public String toString() {
        return "VaultSecureStoreConfig{address='" + this.address + "', secretPath='" + this.secretPath + "', pollingInterval='" + this.pollingInterval + "', token='***'}";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultSecureStoreConfig)) {
            return false;
        }
        VaultSecureStoreConfig other = (VaultSecureStoreConfig)o;
        if (!Objects.equals(this.address, other.address)) {
            return false;
        }
        if (!Objects.equals(this.secretPath, other.secretPath)) {
            return false;
        }
        if (this.pollingInterval != other.pollingInterval) {
            return false;
        }
        return Objects.equals(this.token, other.token);
    }

    public final int hashCode() {
        int result = this.address == null ? 0 : this.address.hashCode();
        result = 31 * result + (this.secretPath == null ? 0 : this.secretPath.hashCode());
        result = 31 * result + this.pollingInterval;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }
}

