/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public final class SetUUIDCodec {
    private SetUUIDCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<UUID> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 17]);
        Iterator<UUID> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 17, iterator.next());
        }
        clientMessage.add(frame);
    }

    public static Set<UUID> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 17;
        HashSet<UUID> result = new HashSet<UUID>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            result.add(FixedSizeTypesCodec.decodeUUID(frame.content, i * 17));
        }
        return result;
    }
}

