/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleAsyncTaskExecutorBuilder {
    private final Boolean virtualThreads;
    private final String threadNamePrefix;
    private final Integer concurrencyLimit;
    private final TaskDecorator taskDecorator;
    private final Set<SimpleAsyncTaskExecutorCustomizer> customizers;

    public SimpleAsyncTaskExecutorBuilder() {
        this(null, null, null, null, null);
    }

    private SimpleAsyncTaskExecutorBuilder(Boolean virtualThreads, String threadNamePrefix, Integer concurrencyLimit, TaskDecorator taskDecorator, Set<SimpleAsyncTaskExecutorCustomizer> customizers) {
        this.virtualThreads = virtualThreads;
        this.threadNamePrefix = threadNamePrefix;
        this.concurrencyLimit = concurrencyLimit;
        this.taskDecorator = taskDecorator;
        this.customizers = customizers;
    }

    public SimpleAsyncTaskExecutorBuilder threadNamePrefix(String threadNamePrefix) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.customizers);
    }

    public SimpleAsyncTaskExecutorBuilder virtualThreads(Boolean virtualThreads) {
        return new SimpleAsyncTaskExecutorBuilder(virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.customizers);
    }

    public SimpleAsyncTaskExecutorBuilder concurrencyLimit(Integer concurrencyLimit) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, concurrencyLimit, this.taskDecorator, this.customizers);
    }

    public SimpleAsyncTaskExecutorBuilder taskDecorator(TaskDecorator taskDecorator) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, taskDecorator, this.customizers);
    }

    public SimpleAsyncTaskExecutorBuilder customizers(SimpleAsyncTaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        return this.customizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskExecutorBuilder customizers(Iterable<? extends SimpleAsyncTaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.append(null, customizers));
    }

    public SimpleAsyncTaskExecutorBuilder additionalCustomizers(SimpleAsyncTaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskExecutorBuilder additionalCustomizers(Iterable<? extends SimpleAsyncTaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.append(this.customizers, customizers));
    }

    public SimpleAsyncTaskExecutor build() {
        return this.configure(new SimpleAsyncTaskExecutor());
    }

    public <T extends SimpleAsyncTaskExecutor> T build(Class<T> taskExecutorClass) {
        return (T)this.configure((SimpleAsyncTaskExecutor)BeanUtils.instantiateClass(taskExecutorClass));
    }

    public <T extends SimpleAsyncTaskExecutor> T configure(T taskExecutor) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.virtualThreads).to(arg_0 -> taskExecutor.setVirtualThreads(arg_0));
        map.from(this.threadNamePrefix).whenHasText().to(arg_0 -> taskExecutor.setThreadNamePrefix(arg_0));
        map.from(this.concurrencyLimit).to(arg_0 -> taskExecutor.setConcurrencyLimit(arg_0));
        map.from(this.taskDecorator).to(arg_0 -> taskExecutor.setTaskDecorator(arg_0));
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.forEach(customizer -> customizer.customize(taskExecutor));
        }
        return taskExecutor;
    }

    private <T> Set<T> append(Set<T> set, Iterable<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set != null ? set : Collections.emptySet());
        additions.forEach(result::add);
        return Collections.unmodifiableSet(result);
    }
}

