/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;

public abstract class AbstractSimpleType
implements EdmSimpleType {
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String getNamespace() throws EdmException {
        return "Edm";
    }

    public EdmTypeKind getKind() {
        return EdmTypeKind.SIMPLE;
    }

    public String getName() throws EdmException {
        String name = this.getClass().getSimpleName();
        return name.startsWith("Edm") ? name.substring(3) : name;
    }

    public boolean isCompatible(EdmSimpleType simpleType) {
        return this.equals(simpleType);
    }

    public boolean validate(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        try {
            this.valueOfString(value, literalKind, facets, this.getDefaultType());
            return true;
        }
        catch (EdmSimpleTypeException e) {
            return false;
        }
    }

    public final <T> T valueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (value == null) {
            if (facets == null || facets.isNullable() == null || facets.isNullable().booleanValue()) {
                return null;
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_NULL_NOT_ALLOWED);
        }
        if (literalKind == null) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_KIND_MISSING);
        }
        return this.internalValueOfString(value, literalKind, facets, returnType);
    }

    protected abstract <T> T internalValueOfString(String var1, EdmLiteralKind var2, EdmFacets var3, Class<T> var4) throws EdmSimpleTypeException;

    public final String valueToString(Object value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value == null) {
            if (facets == null || facets.isNullable() == null || facets.isNullable().booleanValue()) {
                return null;
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_NULL_NOT_ALLOWED);
        }
        if (literalKind == null) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_KIND_MISSING);
        }
        String result = this.internalValueToString(value, literalKind, facets);
        return literalKind == EdmLiteralKind.URI ? this.toUriLiteral(result) : result;
    }

    protected abstract <T> String internalValueToString(T var1, EdmLiteralKind var2, EdmFacets var3) throws EdmSimpleTypeException;

    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return literal;
    }

    public String toString() {
        try {
            return this.getNamespace() + "." + this.getName();
        }
        catch (EdmException e) {
            return super.toString();
        }
    }
}

