/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;

public final class ODataEntityParser {
    private ODataJPAContext context;
    private Edm edm;
    private String serviceRoot = null;

    public ODataEntityParser(ODataJPAContext context) {
        this.context = context;
        try {
            this.serviceRoot = context.getODataContext().getPathInfo().getServiceRoot().toString();
        }
        catch (ODataException e) {
            this.serviceRoot = "";
        }
    }

    public final ODataEntry parseEntry(EdmEntitySet entitySet, InputStream content, String requestContentType, boolean merge) throws ODataBadRequestException {
        ODataEntry entryValues;
        try {
            EntityProviderReadProperties entityProviderProperties = EntityProviderReadProperties.init().mergeSemantic(merge).build();
            entryValues = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)entitySet, (InputStream)content, (EntityProviderReadProperties)entityProviderProperties);
        }
        catch (EntityProviderException e) {
            throw new ODataBadRequestException(ODataBadRequestException.BODY, (Throwable)e);
        }
        return entryValues;
    }

    public final UriInfo parseURISegmentWithCustomOptions(int segmentFromIndex, int segmentToIndex, Map<String, String> options) throws ODataJPARuntimeException {
        UriInfo uriInfo = null;
        if (segmentFromIndex == segmentToIndex || segmentFromIndex > segmentToIndex || segmentFromIndex < 0) {
            return uriInfo;
        }
        try {
            this.edm = this.getEdm();
            List pathSegments = this.context.getODataContext().getPathInfo().getODataSegments();
            List subPathSegments = pathSegments.subList(segmentFromIndex, segmentToIndex);
            uriInfo = UriParser.parse((Edm)this.edm, subPathSegments, options);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return uriInfo;
    }

    public final UriInfo parseURISegment(int segmentFromIndex, int segmentToIndex) throws ODataJPARuntimeException {
        UriInfo uriInfo = null;
        if (segmentFromIndex == segmentToIndex || segmentFromIndex > segmentToIndex || segmentFromIndex < 0) {
            return uriInfo;
        }
        try {
            this.edm = this.getEdm();
            List pathSegments = this.context.getODataContext().getPathInfo().getODataSegments();
            List subPathSegments = pathSegments.subList(segmentFromIndex, segmentToIndex);
            uriInfo = UriParser.parse((Edm)this.edm, subPathSegments, Collections.emptyMap());
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return uriInfo;
    }

    public final UriInfo parseLink(EdmEntitySet entitySet, InputStream content, String contentType) throws ODataJPARuntimeException {
        String uriString = null;
        UriInfo uri = null;
        try {
            uriString = EntityProvider.readLink((String)contentType, (EdmEntitySet)entitySet, (InputStream)content);
            ODataContext odataContext = this.context.getODataContext();
            String svcRoot = odataContext.getPathInfo().getServiceRoot().toString();
            String path = uriString.startsWith(svcRoot.toString()) ? uriString.substring(svcRoot.length()) : uriString;
            List<PathSegment> pathSegment = this.getPathSegment(path);
            this.edm = this.getEdm();
            uri = UriParser.parse((Edm)this.edm, pathSegment, Collections.emptyMap());
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return uri;
    }

    public UriInfo parseLinkSegments(List<String> linkSegments, Map<String, String> options) throws ODataJPARuntimeException {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (String link : linkSegments) {
            List<PathSegment> pathSegment = this.getPathSegment(link);
            pathSegments.addAll(pathSegment);
        }
        UriInfo uriInfo = null;
        try {
            this.edm = this.getEdm();
            uriInfo = UriParser.parse((Edm)this.edm, pathSegments, options);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return uriInfo;
    }

    public UriInfo parseBindingLink(String link, Map<String, String> options) throws ODataJPARuntimeException {
        List<PathSegment> pathSegment = this.getPathSegment(link);
        UriInfo uriInfo = null;
        try {
            this.edm = this.getEdm();
            uriInfo = UriParser.parse((Edm)this.edm, pathSegment, options);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return uriInfo;
    }

    private Edm getEdm() throws ODataException {
        if (this.edm == null) {
            this.edm = this.context.getODataContext().getService().getEntityDataModel();
        }
        return this.edm;
    }

    private List<PathSegment> getPathSegment(String path) {
        String trimmedPath = path.replace(this.serviceRoot, "");
        String[] splittedPath = trimmedPath.split("/");
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (final String pathSegmentString : splittedPath) {
            PathSegment pathSegment = new PathSegment(){

                public String getPath() {
                    return pathSegmentString;
                }

                public Map<String, List<String>> getMatrixParameters() {
                    return null;
                }
            };
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }
}

