/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.datasource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.olingo.odata2.annotation.processor.core.datasource.ValueAccess;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;

public class BeanPropertyAccess
implements ValueAccess {
    @Override
    public <T> Object getPropertyValue(T data, EdmProperty property) throws ODataException {
        return this.getValue(data, this.getGetterMethodName(property));
    }

    @Override
    public <T, V> void setPropertyValue(T data, EdmProperty property, V value) throws ODataException {
        String methodName = this.getSetterMethodName(this.getGetterMethodName(property));
        if (methodName != null) {
            this.setValue(data, methodName, value);
        }
    }

    @Override
    public <T> Class<?> getPropertyType(T data, EdmProperty property) throws ODataException {
        return this.getType(data, this.getGetterMethodName(property));
    }

    @Override
    public <T> Object getMappingValue(T data, EdmMapping mapping) throws ODataException {
        if (mapping != null && mapping.getMediaResourceMimeTypeKey() != null) {
            return this.getValue(data, mapping.getMediaResourceMimeTypeKey());
        }
        return null;
    }

    @Override
    public <T, V> void setMappingValue(T data, EdmMapping mapping, V value) throws ODataException {
        if (mapping != null && mapping.getMediaResourceMimeTypeKey() != null) {
            this.setValue(data, this.getSetterMethodName(mapping.getMediaResourceMimeTypeKey()), value);
        }
    }

    private String getGetterMethodName(EdmProperty property) throws EdmException {
        String prefix = this.isBooleanProperty(property) ? "is" : "get";
        String defaultMethodName = prefix + property.getName();
        return property.getMapping() == null || property.getMapping().getInternalName() == null ? defaultMethodName : property.getMapping().getInternalName();
    }

    private boolean isBooleanProperty(EdmProperty property) throws EdmException {
        return property.isSimple() && property.getType() == EdmSimpleTypeKind.Boolean.getEdmSimpleTypeInstance();
    }

    private String getSetterMethodName(String getterMethodName) {
        return getterMethodName.contains(".") ? null : getterMethodName.replaceFirst("^is", "set").replaceFirst("^get", "set");
    }

    private <T> Object getValue(T data, String methodName) throws ODataNotFoundException {
        Object dataObject = data;
        for (String method : methodName.split("\\.", -1)) {
            if (dataObject == null) continue;
            try {
                dataObject = dataObject.getClass().getMethod(method, new Class[0]).invoke(dataObject, new Object[0]);
            }
            catch (SecurityException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
        }
        return dataObject;
    }

    private <T, V> void setValue(T data, String methodName, V value) throws ODataNotFoundException {
        try {
            boolean found = false;
            for (Method method : Arrays.asList(data.getClass().getMethods())) {
                if (!method.getName().equals(methodName)) continue;
                found = true;
                Class<?> type = method.getParameterTypes()[0];
                if (value == null) {
                    if (type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Character.TYPE)) {
                        method.invoke(data, 0);
                        break;
                    }
                    if (type.equals(Float.TYPE) || type.equals(Double.TYPE)) {
                        method.invoke(data, 0.0);
                        break;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        method.invoke(data, false);
                        break;
                    }
                    method.invoke(data, value);
                    break;
                }
                method.invoke(data, value);
                break;
            }
            if (!found) {
                throw new ODataNotFoundException(null);
            }
        }
        catch (SecurityException e) {
            throw new ODataNotFoundException(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ODataNotFoundException(null, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ODataNotFoundException(null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ODataNotFoundException(null, (Throwable)e);
        }
    }

    private <T> Class<?> getType(T data, String methodName) throws ODataNotFoundException {
        if (data == null) {
            throw new ODataNotFoundException(ODataHttpException.COMMON);
        }
        Class<Object> type = data.getClass();
        for (String method : methodName.split("\\.", -1)) {
            try {
                type = type.getMethod(method, new Class[0]).getReturnType();
                if (!type.isPrimitive()) continue;
                if (type == Boolean.TYPE) {
                    type = Boolean.class;
                    continue;
                }
                if (type == Byte.TYPE) {
                    type = Byte.class;
                    continue;
                }
                if (type == Short.TYPE) {
                    type = Short.class;
                    continue;
                }
                if (type == Integer.TYPE) {
                    type = Integer.class;
                    continue;
                }
                if (type == Long.TYPE) {
                    type = Long.class;
                    continue;
                }
                if (type == Float.TYPE) {
                    type = Float.class;
                    continue;
                }
                if (type != Double.TYPE) continue;
                type = Double.class;
            }
            catch (SecurityException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ODataNotFoundException(ODataHttpException.COMMON, (Throwable)e);
            }
        }
        return type;
    }
}

