/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.processor;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;
import org.apache.olingo.odata2.api.uri.PathInfo;

public abstract class ODataRequest {
    public abstract String getRequestHeaderValue(String var1);

    public abstract Map<String, List<String>> getRequestHeaders();

    public abstract InputStream getBody();

    public abstract PathInfo getPathInfo();

    public abstract ODataHttpMethod getMethod();

    public abstract String getHttpMethod();

    public abstract List<Locale> getAcceptableLanguages();

    public abstract String getContentType();

    public abstract List<String> getAcceptHeaders();

    public abstract Map<String, String> getQueryParameters();

    public abstract Map<String, List<String>> getAllQueryParameters();

    public static ODataRequestBuilder requestHeaders(Map<String, List<String>> headers) {
        return ODataRequest.newBuilder().requestHeaders(headers);
    }

    public static ODataRequestBuilder body(InputStream body) {
        return ODataRequest.newBuilder().body(body);
    }

    public static ODataRequestBuilder pathInfo(PathInfo pathInfo) {
        return ODataRequest.newBuilder().pathInfo(pathInfo);
    }

    public static ODataRequestBuilder method(ODataHttpMethod method) {
        return ODataRequest.newBuilder().method(method);
    }

    public static ODataRequestBuilder acceptableLanguages(List<Locale> acceptableLanguages) {
        return ODataRequest.newBuilder().acceptableLanguages(acceptableLanguages);
    }

    public static ODataRequestBuilder contentType(String contentType) {
        return ODataRequest.newBuilder().contentType(contentType);
    }

    public static ODataRequestBuilder acceptHeaders(List<String> acceptHeaders) {
        return ODataRequest.newBuilder().acceptHeaders(acceptHeaders);
    }

    public static ODataRequestBuilder queryParameters(Map<String, String> queryParameters) {
        return ODataRequest.newBuilder().queryParameters(queryParameters);
    }

    public static ODataRequestBuilder allQueryParameters(Map<String, List<String>> allQueryParameters) {
        return ODataRequest.newBuilder().allQueryParameters(allQueryParameters);
    }

    public static ODataRequestBuilder fromRequest(ODataRequest request) {
        return ODataRequest.newBuilder().fromRequest(request);
    }

    public static ODataRequestBuilder newBuilder() {
        return ODataRequestBuilder.newInstance();
    }

    public static abstract class ODataRequestBuilder {
        protected ODataRequestBuilder() {
        }

        private static ODataRequestBuilder newInstance() {
            return RuntimeDelegate.createODataRequestBuilder();
        }

        public abstract ODataRequest build();

        public abstract ODataRequestBuilder requestHeaders(Map<String, List<String>> var1);

        public abstract ODataRequestBuilder httpMethod(String var1);

        public abstract ODataRequestBuilder body(InputStream var1);

        public abstract ODataRequestBuilder pathInfo(PathInfo var1);

        public abstract ODataRequestBuilder method(ODataHttpMethod var1);

        public abstract ODataRequestBuilder acceptableLanguages(List<Locale> var1);

        public abstract ODataRequestBuilder contentType(String var1);

        public abstract ODataRequestBuilder acceptHeaders(List<String> var1);

        public abstract ODataRequestBuilder queryParameters(Map<String, String> var1);

        public abstract ODataRequestBuilder allQueryParameters(Map<String, List<String>> var1);

        public abstract ODataRequestBuilder fromRequest(ODataRequest var1);
    }
}

