/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.JettyDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.JettyClientHttpRequest;
import org.springframework.http.client.reactive.JettyClientHttpResponse;
import org.springframework.http.client.reactive.JettyResourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JettyClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;
    private JettyDataBufferFactory bufferFactory = new JettyDataBufferFactory();

    public JettyClientHttpConnector() {
        this(new HttpClient());
    }

    public JettyClientHttpConnector(HttpClient httpClient) {
        this(httpClient, null);
    }

    public JettyClientHttpConnector(HttpClient httpClient, @Nullable JettyResourceFactory resourceFactory) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        if (resourceFactory != null) {
            httpClient.setExecutor(resourceFactory.getExecutor());
            httpClient.setByteBufferPool(resourceFactory.getByteBufferPool());
            httpClient.setScheduler(resourceFactory.getScheduler());
        }
        this.httpClient = httpClient;
    }

    @Deprecated
    public JettyClientHttpConnector(JettyResourceFactory resourceFactory, @Nullable Consumer<HttpClient> customizer) {
        this(new HttpClient(), resourceFactory);
        if (customizer != null) {
            customizer.accept(this.httpClient);
        }
    }

    public void setBufferFactory(JettyDataBufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + String.valueOf(uri)));
        }
        if (!this.httpClient.isStarted()) {
            try {
                this.httpClient.start();
            }
            catch (Exception ex) {
                return Mono.error((Throwable)ex);
            }
        }
        Request jettyRequest = this.httpClient.newRequest(uri).method(method.toString());
        JettyClientHttpRequest request = new JettyClientHttpRequest(jettyRequest, (DataBufferFactory)this.bufferFactory);
        return requestCallback.apply(request).then(this.execute(request));
    }

    private Mono<ClientHttpResponse> execute(JettyClientHttpRequest request) {
        return Mono.fromDirect((Publisher)request.toReactiveRequest().response((reactiveResponse, chunkPublisher) -> {
            Flux content = Flux.from((Publisher)chunkPublisher).map(arg_0 -> ((JettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
            return Mono.just((Object)new JettyClientHttpResponse((ReactiveResponse)reactiveResponse, (Flux<DataBuffer>)content));
        }));
    }
}

