/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class InTimestampStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(NS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function rightFn = args.getQuick(1);
        if (rightFn.isConstant()) {
            return new EqTimestampStrConstantFunction(args.getQuick(0), rightFn.getStr(null), argPositions.getQuick(1));
        }
        return new EqTimestampStrFunction(args.getQuick(0), rightFn);
    }

    private static void parseAndApplyIntervalEx(CharSequence seq, LongList out, int position) throws SqlException {
        IntervalUtils.parseIntervalEx(seq, 0, seq.length(), position, out, (short)1);
        IntervalUtils.applyLastEncodedIntervalEx(out);
    }

    public static class EqTimestampStrFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final LongList intervals = new LongList();
        private final Function left;
        private final Function right;

        public EqTimestampStrFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.left.getTimestamp(rec);
            if (ts == Long.MIN_VALUE) {
                return this.negated;
            }
            CharSequence timestampAsString = this.right.getStr(rec);
            if (timestampAsString == null) {
                return this.negated;
            }
            this.intervals.clear();
            try {
                InTimestampStrFunctionFactory.parseAndApplyIntervalEx(timestampAsString, this.intervals, 0);
            }
            catch (SqlException e) {
                return false;
            }
            return this.negated != IntervalUtils.isInIntervals(this.intervals, this.left.getTimestamp(rec));
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }
    }

    private static class EqTimestampStrConstantFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList intervals = new LongList();
        private final Function left;

        public EqTimestampStrConstantFunction(Function left, CharSequence right, int rightPosition) throws SqlException {
            this.left = left;
            InTimestampStrFunctionFactory.parseAndApplyIntervalEx(right, this.intervals, rightPosition);
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != IntervalUtils.isInIntervals(this.intervals, this.left.getTimestamp(rec));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.intervals);
        }
    }
}

