/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

public enum ResourceType {
    Bucket("/buckets"),
    Policy("/policies"),
    Proxy("/proxy"),
    Tenant("/tenants"),
    Actuator("/actuator"),
    Swagger("/swagger");

    final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static ResourceType valueOfValue(String rawValue) {
        ResourceType type = null;
        for (ResourceType rt : ResourceType.values()) {
            if (!rt.getValue().equals(rawValue)) continue;
            type = rt;
            break;
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown resource type value " + rawValue);
        }
        return type;
    }

    public static ResourceType mapFullResourcePathToResourceType(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Resource path must not be null");
        }
        ResourceType type = null;
        for (ResourceType rt : ResourceType.values()) {
            String rtValue = rt.getValue();
            if (!resourcePath.equals(rtValue) && !resourcePath.startsWith(rtValue + "/")) continue;
            type = rt;
            break;
        }
        return type;
    }
}

