/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.pagestore;

import java.util.BitSet;
import v14.h2.message.DbException;
import v14.h2.message.Trace;
import v14.h2.pagestore.PageStore;
import v14.h2.pagestore.PageStreamData;
import v14.h2.pagestore.PageStreamTrunk;
import v14.h2.util.IntArray;

public class PageOutputStream {
    private PageStore store;
    private final Trace trace;
    private final BitSet exclude;
    private final boolean atEnd;
    private final int minPageId;
    private int trunkPageId;
    private int trunkNext;
    private IntArray reservedPages = new IntArray();
    private PageStreamTrunk trunk;
    private int trunkIndex;
    private PageStreamData data;
    private int reserved;
    private boolean needFlush;
    private boolean writing;
    private int pageCount;
    private int logKey;

    public PageOutputStream(PageStore pageStore, int n, BitSet bitSet, int n2, boolean bl) {
        this.trace = pageStore.getTrace();
        this.store = pageStore;
        this.trunkPageId = n;
        this.exclude = bitSet;
        this.logKey = n2 - 1;
        this.atEnd = bl;
        this.minPageId = bl ? n : 0;
    }

    void reserve(int n) {
        if (this.reserved < n) {
            int n2 = this.store.getPageSize();
            int n3 = PageStreamData.getCapacity(n2);
            int n4 = PageStreamTrunk.getPagesAddressed(n2);
            int n5 = 0;
            int n6 = 0;
            do {
                n5 += n4 + 1;
            } while ((n6 += n4 * n3) < n);
            int n7 = this.atEnd ? this.trunkPageId : 0;
            this.store.allocatePages(this.reservedPages, n5, this.exclude, n7);
            this.reserved += n6;
            if (this.data == null) {
                this.initNextData();
            }
        }
    }

    private void initNextData() {
        int n;
        int n2 = n = this.trunk == null ? -1 : this.trunk.getPageData(this.trunkIndex++);
        if (n == -1) {
            int n3 = this.trunkPageId;
            if (this.trunkNext != 0) {
                this.trunkPageId = this.trunkNext;
            }
            int n4 = PageStreamTrunk.getPagesAddressed(this.store.getPageSize());
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = this.reservedPages.get(i);
            }
            this.trunkNext = this.reservedPages.get(n4);
            ++this.logKey;
            this.trunk = PageStreamTrunk.create(this.store, n3, this.trunkPageId, this.trunkNext, this.logKey, nArray);
            this.trunkIndex = 0;
            ++this.pageCount;
            this.trunk.write();
            this.reservedPages.removeRange(0, n4 + 1);
            n = this.trunk.getPageData(this.trunkIndex++);
        }
        this.data = PageStreamData.create(this.store, n, this.trunk.getPos(), this.logKey);
        ++this.pageCount;
        this.data.initWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        if (this.writing) {
            DbException.throwInternalError("writing while still writing");
        }
        try {
            this.reserve(n2);
            this.writing = true;
            while (n2 > 0) {
                int n3 = this.data.write(byArray, n, n2);
                if (n3 < n2) {
                    this.storePage();
                    this.initNextData();
                }
                this.reserved -= n3;
                n += n3;
                n2 -= n3;
            }
            this.needFlush = true;
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage " + this.data);
        }
        this.data.write();
    }

    public void flush() {
        if (this.needFlush) {
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() {
        this.store = null;
    }

    int getCurrentDataPageId() {
        return this.data.getPos();
    }

    void fillPage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage fill " + this.data.getPos());
        }
        this.reserve(this.data.getRemaining() + 1);
        this.reserved -= this.data.getRemaining();
        this.data.write();
        this.initNextData();
    }

    long getSize() {
        return this.pageCount * this.store.getPageSize();
    }

    void free(PageStreamTrunk pageStreamTrunk) {
        this.pageCount -= pageStreamTrunk.free(0);
    }

    void freeReserved() {
        if (this.reservedPages.size() > 0) {
            int[] nArray = new int[this.reservedPages.size()];
            this.reservedPages.toArray(nArray);
            this.reservedPages = new IntArray();
            this.reserved = 0;
            for (int n : nArray) {
                this.store.free(n, false);
            }
        }
    }

    int getMinPageId() {
        return this.minPageId;
    }
}

