/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.cryptography.KeyEncryptionKey;
import com.azure.core.http.HttpPipeline;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.models.JsonWebKey;

@ServiceClient(builder=KeyEncryptionKeyClientBuilder.class)
public final class KeyEncryptionKeyClient
extends CryptographyClient
implements KeyEncryptionKey {
    KeyEncryptionKeyClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version) {
        super(keyId, pipeline, version);
    }

    KeyEncryptionKeyClient(JsonWebKey jsonWebKey) {
        super(jsonWebKey);
    }

    public String getKeyId() {
        return this.keyId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] wrapKey(String algorithm, byte[] key) {
        KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
        return this.wrapKey(wrapAlgorithm, key).getEncryptedKey();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] unwrapKey(String algorithm, byte[] encryptedKey) {
        KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
        return this.unwrapKey(wrapAlgorithm, encryptedKey).getKey();
    }
}

